/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.display.ImageDisplayService;
import net.imagej.event.DataRestructuredEvent;
import net.imagej.plugins.commands.restructure.SplitChannelsContext;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;
import org.scijava.display.event.DisplayActivatedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class SplitChannelsContextMonitor
extends AbstractService {
    @Parameter
    private EventService eventService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private ImageDisplayService imageDisplayService;

    @EventHandler
    protected void onEvent(DisplayActivatedEvent event) {
        this.checkContext();
    }

    @EventHandler
    protected void onEvent(DataRestructuredEvent event) {
        this.checkContext();
    }

    private void checkContext() {
        Dataset dataset = this.imageDisplayService.getActiveDataset();
        if (dataset == null) {
            this.setContextAppropriate(false);
            return;
        }
        int channelIndex = dataset.dimensionIndex(Axes.CHANNEL);
        if (channelIndex < 0) {
            this.setContextAppropriate(false);
            return;
        }
        long channelCount = dataset.dimension(channelIndex);
        this.setContextAppropriate(channelCount > 1L);
    }

    private void setContextAppropriate(boolean enabled) {
        CommandInfo info = this.commandService.getCommand(SplitChannelsContext.class);
        info.setEnabled(enabled);
        info.update(this.eventService);
    }
}

