/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.awt;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.imagej.render.TextRenderer;

public class AWTTextRenderer
implements TextRenderer {
    private static final int EXTRA_SPACE = 10;
    private int bufferSizeU;
    private int bufferSizeV;
    private BufferedImage textBuffer;
    private WritableRaster textRaster;
    private String fontFamily = "SansSerif";
    private int fontStyle = 0;
    private int fontSize = 12;
    private Font font;
    private int[] pixels;
    private boolean antialiasing = false;

    public AWTTextRenderer() {
        this.buildFont();
        this.initTextBuffer("42 is my favorite number");
    }

    public void renderText(String text) {
        this.initTextBuffer(text);
        Graphics2D g = this.textBuffer.createGraphics();
        this.setAntialiasedText(g, this.antialiasing);
        g.setFont(this.font);
        int x = 10;
        int y = this.bufferSizeV / 2;
        g.drawString(text, 10, y);
        g.dispose();
    }

    public int getPixelsWidth() {
        return this.bufferSizeU;
    }

    public int getPixelsHeight() {
        return this.bufferSizeV;
    }

    public int[] getPixels() {
        if (this.pixels != null && this.pixels.length != this.bufferSizeU * this.bufferSizeV) {
            this.pixels = null;
        }
        this.pixels = this.textRaster.getPixels(0, 0, this.bufferSizeU, this.bufferSizeV, this.pixels);
        return this.pixels;
    }

    public void setFontFamily(TextRenderer.FontFamily family) {
        String familyString;
        switch (family) {
            case MONOSPACED: {
                familyString = "Monospaced";
                break;
            }
            case SERIF: {
                familyString = "Serif";
                break;
            }
            case SANS_SERIF: {
                familyString = "SansSerif";
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown font family: " + family);
            }
        }
        if (this.font.getFamily().equalsIgnoreCase(familyString)) {
            return;
        }
        this.fontFamily = familyString;
        this.buildFont();
    }

    public TextRenderer.FontFamily getFontFamily() {
        if (this.fontFamily.equals("Monospaced")) {
            return TextRenderer.FontFamily.MONOSPACED;
        }
        if (this.fontFamily.equals("Serif")) {
            return TextRenderer.FontFamily.SERIF;
        }
        if (this.fontFamily.equals("SansSerif")) {
            return TextRenderer.FontFamily.SANS_SERIF;
        }
        throw new IllegalArgumentException("unknown font family: " + this.fontFamily);
    }

    public void setFontStyle(TextRenderer.FontStyle style) {
        int styleInt;
        switch (style) {
            case PLAIN: {
                styleInt = 0;
                break;
            }
            case BOLD: {
                styleInt = 1;
                break;
            }
            case ITALIC: {
                styleInt = 2;
                break;
            }
            case BOLD_ITALIC: {
                styleInt = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown font style: " + style);
            }
        }
        if (this.font.getStyle() == styleInt) {
            return;
        }
        this.fontStyle = styleInt;
        this.buildFont();
    }

    public TextRenderer.FontStyle getFontStyle() {
        switch (this.fontStyle) {
            case 0: {
                return TextRenderer.FontStyle.PLAIN;
            }
            case 1: {
                return TextRenderer.FontStyle.BOLD;
            }
            case 2: {
                return TextRenderer.FontStyle.ITALIC;
            }
            case 3: {
                return TextRenderer.FontStyle.BOLD_ITALIC;
            }
        }
        throw new IllegalArgumentException("unknown font style: " + this.fontStyle);
    }

    public void setFontSize(int size) {
        if (size <= 0) {
            return;
        }
        if (this.font.getSize() == size) {
            return;
        }
        this.fontSize = size;
        this.buildFont();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setAntialiasing(boolean val) {
        this.antialiasing = val;
    }

    public boolean getAntialiasing() {
        return this.antialiasing;
    }

    private void buildFont() {
        this.font = new Font(this.fontFamily, this.fontStyle, this.fontSize);
    }

    private void initTextBuffer(String text) {
        if (this.textBuffer == null) {
            this.bufferSizeU = 200;
            this.bufferSizeV = 20;
            this.textBuffer = new BufferedImage(this.bufferSizeU, this.bufferSizeV, 10);
            this.textRaster = this.textBuffer.getRaster();
        }
        Dimension extents = this.calcTextSize(text);
        if (extents.width > this.textBuffer.getWidth() || extents.height > this.textBuffer.getHeight()) {
            this.bufferSizeU = extents.width;
            this.bufferSizeV = extents.height;
            this.textBuffer = new BufferedImage(this.bufferSizeU, this.bufferSizeV, 10);
            this.textRaster = this.textBuffer.getRaster();
        } else {
            this.clearTextBuffer();
        }
    }

    private void clearTextBuffer() {
        for (int u = 0; u < this.bufferSizeU; ++u) {
            for (int v = 0; v < this.bufferSizeV; ++v) {
                this.textRaster.setSample(u, v, 0, 0);
            }
        }
    }

    private Dimension calcTextSize(String txt) {
        Graphics g = this.textBuffer.getGraphics();
        FontMetrics metrics = g.getFontMetrics(this.font);
        g.dispose();
        int width = metrics.charsWidth(txt.toCharArray(), 0, txt.length());
        Dimension extents = new Dimension();
        extents.width = width + 10;
        extents.height = metrics.getHeight() + 20;
        return extents;
    }

    private void setAntialiasedText(Graphics2D g, boolean antialiasedText) {
        Object antialias = antialiasedText ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias);
    }
}

