/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.hdf5;

import bdv.export.ExportMipmapInfo;
import bdv.export.ProgressWriter;
import bdv.export.ProposeMipmaps;
import bdv.export.SubTaskProgressWriter;
import bdv.export.WriteSequenceToHdf5;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.hdf5.DummyProgressWriter;
import net.imglib2.trainable_segmentation.RevampUtils;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public class HDF5Saver {
    private ProgressWriter progressWriter = new DummyProgressWriter();
    private final File hdf5;
    private final File xml;
    private final SpimDataMinimal data;
    private ArrayList<Partition> partitions = null;
    private Map<Integer, ExportMipmapInfo> mipmapInfo;

    public HDF5Saver(RandomAccessibleInterval<?> image, String filename) {
        File file = new File(filename);
        this.hdf5 = this.replaceExtension(file, "h5");
        this.xml = this.replaceExtension(file, "xml");
        this.data = this.wrapAsSpimData(image, this.xml.getParentFile());
        this.mipmapInfo = ProposeMipmaps.proposeMipmaps((AbstractSequenceDescription)this.data.getSequenceDescription());
    }

    public void setPartitions(int timepointsPerPartition, int setupsPerPartion) {
        List timePoints = ((SequenceDescriptionMinimal)this.data.getSequenceDescription()).getTimePoints().getTimePointsOrdered();
        List setups = ((SequenceDescriptionMinimal)this.data.getSequenceDescription()).getViewSetupsOrdered();
        String basename = HDF5Saver.removeExtension(this.hdf5.getAbsolutePath(), "h5");
        this.partitions = Partition.split((List)timePoints, (List)setups, (int)timepointsPerPartition, (int)setupsPerPartion, (String)basename);
    }

    public void setProgressWriter(ProgressWriter progressWriter) {
        this.progressWriter = progressWriter;
    }

    public void writeAll() {
        this.writeAllPartitions();
        this.writeXmlAndHdf5();
    }

    public void writeXmlAndHdf5() {
        this.writeHdf5();
        this.writeXml();
    }

    private void writeHdf5() {
        if (this.partitions == null) {
            this.writeHDF5Block();
        } else {
            this.writeHDF5Partitioned();
        }
    }

    private void writeXml() {
        try {
            Hdf5ImageLoader imgLoader = new Hdf5ImageLoader(this.hdf5, this.partitions, this.data.getSequenceDescription());
            SpimDataMinimal spimData = new SpimDataMinimal(this.data, (BasicImgLoader)imgLoader);
            new XmlIoSpimDataMinimal().save((AbstractSpimData)spimData, this.xml.getAbsolutePath());
        }
        catch (SpimDataException e) {
            throw new RuntimeException(e);
        }
    }

    private File replaceExtension(File file, String newExtension) {
        String nameWithoutExtension = HDF5Saver.removeExtension(file.getName(), "h5", "xml");
        return new File(file.getParentFile(), nameWithoutExtension + "." + newExtension);
    }

    private SpimDataMinimal wrapAsSpimData(RandomAccessibleInterval<?> image, File basePath) {
        return HDF5Saver.oneImageSpimData(this.sliceTime(this.ensure3d(HDF5Saver.toUnsignedShortType(image))), basePath);
    }

    private <T> RandomAccessibleInterval<T> ensure3d(RandomAccessibleInterval<T> image) {
        if (image.numDimensions() == 2) {
            return Views.addDimension(image, (long)0L, (long)0L);
        }
        return image;
    }

    private <T> List<RandomAccessibleInterval<T>> sliceTime(RandomAccessibleInterval<T> image) {
        if (image.numDimensions() == 4) {
            return RevampUtils.slices(image);
        }
        return Collections.singletonList(image);
    }

    private static <T> RandomAccessibleInterval<UnsignedShortType> toUnsignedShortType(RandomAccessibleInterval<T> image) {
        Object type = Util.getTypeFromInterval(image);
        if (type instanceof UnsignedShortType) {
            return image;
        }
        Converter<?, UnsignedShortType> converter = HDF5Saver.getConverter(type);
        return Converters.convert(image, converter, (Type)new UnsignedShortType());
    }

    private static Converter<?, UnsignedShortType> getConverter(Object type) {
        if (type instanceof IntegerType) {
            return (i, o) -> o.set(i.getInteger());
        }
        if (type instanceof FloatType) {
            return (i, o) -> o.set((int)(i.getRealFloat() * 65535.0f));
        }
        if (type instanceof DoubleType) {
            return (i, o) -> o.set((int)(i.getRealDouble() * 65535.0));
        }
        if (type instanceof RealType) {
            return (i, o) -> o.setReal(i.getRealDouble());
        }
        throw new UnsupportedOperationException();
    }

    private void writeHDF5Block() {
        Map mipmapInfo = ProposeMipmaps.proposeMipmaps((AbstractSequenceDescription)this.data.getSequenceDescription());
        WriteSequenceToHdf5.writeHdf5File((AbstractSequenceDescription)this.data.getSequenceDescription(), (Map)mipmapInfo, (boolean)true, (File)this.hdf5, null, null, (int)8, (ProgressWriter)this.progressWriter);
    }

    private void writeHDF5Partitioned() {
        SequenceDescriptionMinimal sequenceDescription = (SequenceDescriptionMinimal)this.data.getSequenceDescription();
        WriteSequenceToHdf5.writeHdf5PartitionLinkFile((AbstractSequenceDescription)sequenceDescription, this.mipmapInfo, this.partitions, (File)this.hdf5);
    }

    public void writeAllPartitions() {
        if (this.partitions == null) {
            return;
        }
        int size = this.numberOfPartitions();
        for (int i = 0; i < size; ++i) {
            double start = 0.95 * (double)i / (double)size;
            double end = 0.95 * (double)(i + 1) / (double)size;
            SubTaskProgressWriter p = new SubTaskProgressWriter(this.progressWriter, start, end);
            this.writePartition(i, (ProgressWriter)p);
        }
    }

    public int numberOfPartitions() {
        return this.partitions == null ? 0 : this.partitions.size();
    }

    public void writePartition(int index) {
        this.writePartition(index, this.progressWriter);
    }

    private void writePartition(int index, ProgressWriter progressWriter) {
        WriteSequenceToHdf5.writeHdf5PartitionFile((AbstractSequenceDescription)this.data.getSequenceDescription(), this.mipmapInfo, (boolean)true, (Partition)this.partitions.get(index), null, null, (int)8, (ProgressWriter)progressWriter);
    }

    private static String removeExtension(String filename, String ... extensions) {
        for (String extension : extensions) {
            if (!filename.endsWith("." + extension)) continue;
            return filename.substring(0, filename.length() - 1 - extension.length());
        }
        return filename;
    }

    private static <T> SpimDataMinimal oneImageSpimData(final List<RandomAccessibleInterval<T>> frames, File basePath) {
        List timePointList = IntStream.range(0, frames.size()).mapToObj(TimePoint::new).collect(Collectors.toList());
        TimePoints timePoints = new TimePoints(timePointList);
        final BasicViewSetup setup = new BasicViewSetup(0, "image", (Dimensions)frames.get(0), (VoxelDimensions)new FinalVoxelDimensions("pixel", new double[]{1.0, 1.0, 1.0}));
        Map<Integer, BasicViewSetup> setups = Collections.singletonMap(0, setup);
        MissingViews missingViews = null;
        BasicImgLoader imgLoader = new BasicImgLoader(){

            public BasicSetupImgLoader<T> getSetupImgLoader(int i) {
                if (i != setup.getId()) {
                    throw new IllegalArgumentException();
                }
                return new BasicSetupImgLoader<T>(){

                    public RandomAccessibleInterval<T> getImage(int timeId, ImgLoaderHint ... imgLoaderHints) {
                        return (RandomAccessibleInterval)frames.get(timeId);
                    }

                    public T getImageType() {
                        return Util.getTypeFromInterval((Interval)((Interval)frames.get(0)));
                    }
                };
            }
        };
        SequenceDescriptionMinimal sequence = new SequenceDescriptionMinimal(timePoints, setups, imgLoader, missingViews);
        List viewRegistrationList = timePointList.stream().map(x -> new ViewRegistration(x.getId(), setup.getId())).collect(Collectors.toList());
        ViewRegistrations registrations = new ViewRegistrations(viewRegistrationList);
        return new SpimDataMinimal(basePath, sequence, registrations);
    }
}

