/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit;

import bdv.util.BdvHandle;
import bdv.util.BdvHandlePanel;
import bdv.util.BdvOptions;
import bdv.util.BdvSource;
import bdv.util.BdvStackSource;
import bdv.viewer.DisplayMode;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.imglib2.labkit.ActionsAndBehaviours;
import net.imglib2.labkit.bdv.BdvAutoContrast;
import net.imglib2.labkit.bdv.BdvLayer;
import net.imglib2.labkit.bdv.BdvLayerLink;
import net.imglib2.labkit.brush.ChangeLabel;
import net.imglib2.labkit.brush.FloodFillController;
import net.imglib2.labkit.brush.LabelBrushController;
import net.imglib2.labkit.brush.SelectLabelController;
import net.imglib2.labkit.labeling.LabelsLayer;
import net.imglib2.labkit.models.Holder;
import net.imglib2.labkit.models.ImageLabelingModel;
import net.imglib2.labkit.panel.LabelToolsPanel;
import net.miginfocom.swing.MigLayout;
import org.scijava.ui.behaviour.util.AbstractNamedAction;

public class BasicLabelingComponent
extends JPanel
implements AutoCloseable {
    private final Holder<BdvStackSource<?>> imageSource;
    private BdvHandle bdvHandle;
    private final JFrame dialogBoxOwner;
    private ActionsAndBehaviours actionsAndBehaviours;
    private ImageLabelingModel model;

    public BasicLabelingComponent(JFrame dialogBoxOwner, ImageLabelingModel model) {
        this.model = model;
        this.dialogBoxOwner = dialogBoxOwner;
        this.initBdv(model.spatialDimensions().numDimensions() < 3);
        this.actionsAndBehaviours = new ActionsAndBehaviours(this.bdvHandle);
        this.imageSource = this.initImageLayer();
        this.initLabelsLayer();
        JPanel toolsPanel = this.initBrushLayer();
        this.initPanel(toolsPanel);
        this.model.transformationModel().initialize(this.bdvHandle.getViewerPanel());
    }

    private void initBdv(boolean is2D) {
        BdvOptions options = BdvOptions.options();
        if (is2D) {
            options.is2D();
        }
        this.bdvHandle = new BdvHandlePanel((Frame)this.dialogBoxOwner, options);
        this.bdvHandle.getViewerPanel().setDisplayMode(DisplayMode.FUSED);
    }

    private void initPanel(JPanel toolsPanel) {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][grow]"));
        this.add((Component)toolsPanel, "wrap, growx");
        this.add((Component)this.bdvHandle.getViewerPanel(), "grow");
    }

    private Holder<BdvStackSource<?>> initImageLayer() {
        return this.addBdvLayer(new BdvLayer.FinalLayer(this.model.showable(), "Image", this.model.imageVisibility()));
    }

    private void initLabelsLayer() {
        this.addBdvLayer(new LabelsLayer(this.model));
    }

    public Holder<BdvStackSource<?>> addBdvLayer(BdvLayer layer) {
        return new BdvLayerLink(layer, this.bdvHandle);
    }

    private JPanel initBrushLayer() {
        LabelBrushController brushController = new LabelBrushController(this.bdvHandle.getViewerPanel(), this.model, this.actionsAndBehaviours);
        FloodFillController floodFillController = new FloodFillController(this.bdvHandle.getViewerPanel(), this.model, this.actionsAndBehaviours);
        SelectLabelController selectLabelController = new SelectLabelController(this.bdvHandle.getViewerPanel(), this.model, this.actionsAndBehaviours);
        LabelToolsPanel toolsPanel = new LabelToolsPanel(this.bdvHandle, brushController, floodFillController, selectLabelController);
        this.actionsAndBehaviours.addAction(new ChangeLabel(this.model));
        return toolsPanel;
    }

    public void addShortcuts(Collection<? extends AbstractNamedAction> shortcuts) {
        shortcuts.forEach(this.actionsAndBehaviours::addAction);
    }

    @Override
    public void close() {
        this.bdvHandle.close();
    }

    public void autoContrast() {
        BdvAutoContrast.autoContrast((BdvSource)this.imageSource.get());
    }
}

