/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit;

import bdv.export.ProgressWriter;
import ij.ImagePlus;
import io.scif.img.ImgSaver;
import java.io.File;
import net.imagej.ImgPlus;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.VirtualStackAdapter;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.labkit.segmentation.Segmenter;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.Intervals;

public class BatchSegmenter {
    private final ImgSaver saver = new ImgSaver();
    private final Segmenter segmenter;
    private final ProgressWriter progressWriter;

    public BatchSegmenter(Segmenter segmenter, ProgressWriter progressWriter) {
        this.segmenter = segmenter;
        this.progressWriter = progressWriter;
    }

    public void segment(File inputFile, File outputFile) {
        ImgPlus img = VirtualStackAdapter.wrap((ImagePlus)new ImagePlus(inputFile.getAbsolutePath()));
        ArrayImg result = ArrayImgs.unsignedBytes((long[])Intervals.dimensionsAsLongArray((Dimensions)img));
        this.segmenter.segment((ImgPlus<?>)img, (RandomAccessibleInterval<? extends IntegerType<?>>)result);
        this.saver.saveImg(outputFile.getAbsolutePath(), (Img)result);
    }
}

