/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import net.imglib2.labkit.BasicLabelingComponent;
import net.imglib2.labkit.DefaultExtensible;
import net.imglib2.labkit.actions.LabelEditAction;
import net.imglib2.labkit.models.ColoredLabelsModel;
import net.imglib2.labkit.models.ImageLabelingModel;
import net.imglib2.labkit.panel.ImageInfoPanel;
import net.imglib2.labkit.panel.LabelPanel;
import net.miginfocom.swing.MigLayout;

public class LabelingComponent
extends JPanel
implements AutoCloseable {
    private final BasicLabelingComponent labelingComponent;

    public LabelingComponent(JFrame dialogBoxOwner, ImageLabelingModel model) {
        this.labelingComponent = new BasicLabelingComponent(dialogBoxOwner, model);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][grow]"));
        leftPanel.add((Component)ImageInfoPanel.newFramedImageInfoPanel(model, this.labelingComponent), "grow, wrap");
        DefaultExtensible extensible = new DefaultExtensible(null, dialogBoxOwner);
        new LabelEditAction(extensible, false, new ColoredLabelsModel(model));
        leftPanel.add((Component)LabelPanel.newFramedLabelPanel(model, extensible, false), "grow");
        this.setLayout(new BorderLayout());
        this.add(this.initSplitPane(leftPanel, this.labelingComponent));
    }

    private JSplitPane initSplitPane(JComponent left, JComponent right) {
        JSplitPane panel = new JSplitPane();
        panel.setSize(100, 100);
        panel.setOneTouchExpandable(true);
        panel.setLeftComponent(left);
        panel.setRightComponent(right);
        return panel;
    }

    @Deprecated
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void close() {
        this.labelingComponent.close();
    }
}

