/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import net.imglib2.labkit.BasicLabelingComponent;
import net.imglib2.labkit.DefaultExtensible;
import net.imglib2.labkit.Extensible;
import net.imglib2.labkit.MenuBar;
import net.imglib2.labkit.actions.AddLabelingIoAction;
import net.imglib2.labkit.actions.BatchSegmentAction;
import net.imglib2.labkit.actions.BitmapImportExportAction;
import net.imglib2.labkit.actions.ClassifierIoAction;
import net.imglib2.labkit.actions.ClassifierSettingsAction;
import net.imglib2.labkit.actions.LabelEditAction;
import net.imglib2.labkit.actions.LabelingIoAction;
import net.imglib2.labkit.actions.ResetViewAction;
import net.imglib2.labkit.actions.SegmentationAsLabelAction;
import net.imglib2.labkit.actions.SegmentationExportAction;
import net.imglib2.labkit.menu.MenuKey;
import net.imglib2.labkit.models.ColoredLabelsModel;
import net.imglib2.labkit.models.Holder;
import net.imglib2.labkit.models.ImageLabelingModel;
import net.imglib2.labkit.models.SegmentationItem;
import net.imglib2.labkit.models.SegmentationModel;
import net.imglib2.labkit.panel.ImageInfoPanel;
import net.imglib2.labkit.panel.LabelPanel;
import net.imglib2.labkit.panel.SegmenterPanel;
import net.imglib2.labkit.plugin.MeasureConnectedComponents;
import net.imglib2.labkit.segmentation.PredictionLayer;
import net.imglib2.labkit.segmentation.TrainClassifier;
import net.miginfocom.swing.MigLayout;

public class SegmentationComponent
extends JPanel
implements AutoCloseable {
    private final boolean unmodifiableLabels;
    private final DefaultExtensible extensible;
    private final BasicLabelingComponent labelingComponent;
    private final SegmentationModel segmentationModel;

    public SegmentationComponent(JFrame dialogBoxOwner, SegmentationModel segmentationModel, boolean unmodifiableLabels) {
        this.extensible = new DefaultExtensible(segmentationModel.context(), dialogBoxOwner);
        this.unmodifiableLabels = unmodifiableLabels;
        this.segmentationModel = segmentationModel;
        ImageLabelingModel imageLabelingModel = segmentationModel.imageLabelingModel();
        this.labelingComponent = new BasicLabelingComponent(dialogBoxOwner, imageLabelingModel);
        this.labelingComponent.addBdvLayer(PredictionLayer.createPredictionLayer(segmentationModel));
        this.initActions();
        this.setLayout(new BorderLayout());
        this.add(this.initGui());
    }

    private void initActions() {
        Holder<SegmentationItem> selectedSegmenter = this.segmentationModel.segmenterList().selectedSegmenter();
        ImageLabelingModel labelingModel = this.segmentationModel.imageLabelingModel();
        new TrainClassifier(this.extensible, this.segmentationModel.segmenterList());
        new ClassifierSettingsAction(this.extensible, this.segmentationModel.segmenterList());
        new ClassifierIoAction((Extensible)this.extensible, selectedSegmenter);
        new LabelingIoAction((Extensible)this.extensible, labelingModel);
        new AddLabelingIoAction((Extensible)this.extensible, labelingModel.labeling());
        new SegmentationExportAction((Extensible)this.extensible, labelingModel);
        new ResetViewAction(this.extensible, labelingModel);
        new BatchSegmentAction(this.extensible, selectedSegmenter);
        new SegmentationAsLabelAction(this.extensible, this.segmentationModel);
        new BitmapImportExportAction((Extensible)this.extensible, labelingModel);
        new LabelEditAction(this.extensible, this.unmodifiableLabels, new ColoredLabelsModel(labelingModel));
        MeasureConnectedComponents.addAction(this.extensible, labelingModel);
        this.labelingComponent.addShortcuts(this.extensible.getShortCuts());
    }

    private JPanel initLeftPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][grow][grow]"));
        panel.add((Component)ImageInfoPanel.newFramedImageInfoPanel(this.segmentationModel.imageLabelingModel(), this.labelingComponent), "grow, wrap");
        panel.add((Component)LabelPanel.newFramedLabelPanel(this.segmentationModel.imageLabelingModel(), this.extensible, this.unmodifiableLabels), "grow, wrap, height 0:50");
        panel.add((Component)SegmenterPanel.newFramedSegmeterPanel(this.segmentationModel.segmenterList(), this.extensible), "grow, height 0:50");
        panel.invalidate();
        panel.repaint();
        return panel;
    }

    private JSplitPane initGui() {
        JSplitPane panel = new JSplitPane();
        panel.setOneTouchExpandable(true);
        panel.setLeftComponent(this.initLeftPanel());
        panel.setRightComponent(this.labelingComponent);
        panel.setBorder(BorderFactory.createEmptyBorder());
        return panel;
    }

    @Deprecated
    public JComponent getComponent() {
        return this;
    }

    public JMenu createMenu(MenuKey<Void> key) {
        if (key == MenuBar.SEGMENTER_MENU) {
            return this.extensible.createMenu(SegmentationItem.SEGMENTER_MENU, this.segmentationModel.segmenterList().selectedSegmenter()::get);
        }
        return this.extensible.createMenu(key, () -> null);
    }

    @Override
    public void close() {
        this.labelingComponent.close();
    }

    public JMenuBar getMenuBar() {
        return new MenuBar(this::createMenu);
    }

    public void autoContrast() {
        this.labelingComponent.autoContrast();
    }
}

