/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.actions;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.labkit.Extensible;
import net.imglib2.labkit.MenuBar;
import net.imglib2.labkit.actions.AbstractFileIoAction;
import net.imglib2.labkit.labeling.Label;
import net.imglib2.labkit.labeling.Labeling;
import net.imglib2.labkit.labeling.LabelingSerializer;
import net.imglib2.labkit.models.Holder;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.logic.BitType;

public class AddLabelingIoAction
extends AbstractFileIoAction {
    private final Holder<Labeling> labeling;
    private final LabelingSerializer serializer;

    public AddLabelingIoAction(Extensible extensible, Holder<Labeling> labeling) {
        super(extensible, AbstractFileIoAction.LABELING_FILTER, AbstractFileIoAction.TIFF_FILTER);
        this.labeling = labeling;
        this.serializer = new LabelingSerializer(extensible.context());
        this.initOpenAction(MenuBar.LABELING_MENU, "Import Labeling ...", 100.0f, this::openAdditional, "");
    }

    private void openAdditional(Void ignore, String filename) throws IOException {
        Labeling newLabeling = this.serializer.open(filename);
        this.extendLabeling(this.labeling.get(), newLabeling);
        this.labeling.notifier().notifyListeners();
    }

    private void extendLabeling(Labeling labeling, Labeling newLabeling) {
        newLabeling.iterableRegions().forEach((label, region) -> this.addLabel(labeling, (Label)label, (IterableRegion<BitType>)region));
    }

    private void addLabel(Labeling labeling, Label label, IterableRegion<BitType> region) {
        String newLabelName = this.suggestName(label.name(), labeling.getLabels().stream().map(Label::name).collect(Collectors.toList()));
        if (newLabelName == null) {
            return;
        }
        Label newLabel = labeling.addLabel(newLabelName);
        Cursor cursor = region.cursor();
        RandomAccess<LabelingType<Label>> ra = labeling.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            ra.setPosition((Localizable)cursor);
            ((LabelingType)ra.get()).add((Object)newLabel);
        }
    }

    private String suggestName(String label, List<String> labels) {
        if (!labels.contains(label)) {
            return label;
        }
        for (int i = 0; i < 10000; ++i) {
            String suggestion = label + i;
            if (labels.contains(suggestion)) continue;
            return suggestion;
        }
        return null;
    }
}

