/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.actions;

import java.io.File;
import net.imglib2.labkit.BatchSegmenter;
import net.imglib2.labkit.Extensible;
import net.imglib2.labkit.MenuBar;
import net.imglib2.labkit.models.Holder;
import net.imglib2.labkit.models.SegmentationItem;
import net.imglib2.labkit.segmentation.Segmenter;
import net.imglib2.labkit.utils.progress.StatusServiceProgressWriter;
import org.scijava.Cancelable;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;

public class BatchSegmentAction {
    private final Extensible extensible;
    private final Holder<SegmentationItem> selectedSegmenter;

    public BatchSegmentAction(Extensible extensible, Holder<SegmentationItem> selectedSegmenter) {
        this.extensible = extensible;
        this.selectedSegmenter = selectedSegmenter;
        extensible.addMenuItem(MenuBar.OTHERS_MENU, "Batch Segment Images ...", 0.0f, ignore -> this.segmentImages(), null, "");
    }

    private void segmentImages() {
        CommandService command = (CommandService)this.extensible.context().service(CommandService.class);
        command.run(BatchSegment.class, true, new Object[]{"segmenter", this.selectedSegmenter.get()});
    }

    public static class BatchSegment
    implements Command,
    Cancelable {
        @Parameter(label="input directory", style="directory")
        private File inputDirectory;
        @Parameter(label="output directory", style="directory")
        private File outputDirectory;
        @Parameter
        private StatusService statusService;
        @Parameter
        private Segmenter segmenter;

        public void setSegmenter(Segmenter segmenter) {
            this.segmenter = segmenter;
        }

        public void run() {
            BatchSegmenter batchSegmenter = new BatchSegmenter(this.segmenter, new StatusServiceProgressWriter(this.statusService));
            for (File file : this.inputDirectory.listFiles()) {
                if (!file.isFile()) continue;
                this.processFile(batchSegmenter, file);
            }
        }

        private void processFile(BatchSegmenter batchSegmenter, File file) {
            File outputFile = new File(this.outputDirectory, file.getName());
            try {
                batchSegmenter.segment(file.getAbsoluteFile(), outputFile.getAbsoluteFile());
            }
            catch (Exception e) {
                System.err.print(e);
            }
        }

        public boolean isCanceled() {
            return false;
        }

        public void cancel(String reason) {
        }

        public String getCancelReason() {
            return null;
        }
    }
}

