/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.actions;

import io.scif.services.DatasetIOService;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.labkit.Extensible;
import net.imglib2.labkit.MenuBar;
import net.imglib2.labkit.actions.AbstractFileIoAction;
import net.imglib2.labkit.labeling.Label;
import net.imglib2.labkit.labeling.Labeling;
import net.imglib2.labkit.models.ImageLabelingModel;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.logic.BoolType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.util.Intervals;
import org.scijava.plugin.Parameter;

public class BitmapImportExportAction
extends AbstractFileIoAction {
    private final ImageLabelingModel model;
    @Parameter
    DatasetService datasetService;
    @Parameter
    DatasetIOService datasetIOService;

    public BitmapImportExportAction(Extensible extensible, ImageLabelingModel model) {
        super(extensible, AbstractFileIoAction.TIFF_FILTER);
        this.model = model;
        extensible.context().inject((Object)this);
        this.initOpenAction(MenuBar.LABELING_MENU, "Import Bitmap ...", 100.0f, this::importLabel, "");
        AbstractFileIoAction.Action<Void> voidAction = this::exportLabel;
        this.initSaveAction(MenuBar.LABELING_MENU, "Export Selected Label as Bitmap ...", 101.0f, voidAction, "");
        extensible.addMenuItem(Label.LABEL_MENU, "Export as Bitmap ...", 400.0f, label -> this.openDialogAndThen("Export Label as Bitmap", 1, label, this::exportLabel), null, null);
        extensible.addMenuItem(Label.LABEL_MENU, "Show as Bitmap in ImageJ", 401.0f, this::showLabel, null, "");
    }

    private void showLabel(Label label) {
        ImageJFunctions.show(this.model.labeling().get().getRegion(label), (String)label.name());
    }

    private void exportLabel(Label label, String filename) throws IOException {
        Labeling labeling = this.model.labeling().get();
        RandomAccessibleInterval<BitType> bitmap = labeling.getRegion(label);
        Dataset dataset = this.datasetService.create(this.toUnsignedByteType(bitmap));
        this.datasetIOService.save(dataset, filename);
    }

    private void importLabel(Void ignore, String filename) throws IOException {
        Labeling labeling;
        Dataset image = this.datasetIOService.open(filename);
        if (!Intervals.equals((Interval)image, (Interval)(labeling = this.model.labeling().get()))) {
            JOptionPane.showMessageDialog(this.extensible.dialogParent(), "The resolution of the image does not fit", "Import Label", 0);
        }
        labeling.addLabel("Label \"" + new File(filename).getName() + "\"", this.toBoolType((RandomAccessibleInterval<RealType<?>>)image));
        this.model.labeling().notifier().notifyListeners();
    }

    private void exportLabel(Void ignore, String filename) throws IOException {
        Label label = this.model.selectedLabel().get();
        this.exportLabel(label, filename);
    }

    private RandomAccessibleInterval<BoolType> toBoolType(RandomAccessibleInterval<RealType<?>> image) {
        return Converters.convert(image, (in, out) -> out.set(in.getRealDouble() > 0.5), (Type)new BoolType());
    }

    private RandomAccessibleInterval<UnsignedByteType> toUnsignedByteType(RandomAccessibleInterval<BitType> bitmap) {
        return Converters.convert(bitmap, (in, out) -> out.set(in.getInteger()), (Type)new UnsignedByteType());
    }
}

