/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.actions;

import javax.swing.JOptionPane;
import net.imglib2.labkit.Extensible;
import net.imglib2.labkit.labeling.Label;
import net.imglib2.labkit.models.ColoredLabelsModel;

public class LabelEditAction {
    private final Extensible extensible;
    private final ColoredLabelsModel model;

    public LabelEditAction(Extensible extensible, boolean fixedLabels, ColoredLabelsModel model) {
        this.extensible = extensible;
        this.model = model;
        if (!fixedLabels) {
            extensible.addMenuItem(Label.LABEL_MENU, "Rename", 0.0f, this::renameLabel, null, null);
        }
        if (!fixedLabels) {
            extensible.addMenuItem(Label.LABEL_MENU, "Move up", 100.0f, label -> model.moveLabel((Label)label, -1), null, null);
        }
        if (!fixedLabels) {
            extensible.addMenuItem(Label.LABEL_MENU, "Move down", 101.0f, label -> model.moveLabel((Label)label, 1), null, null);
        }
        extensible.addMenuItem(Label.LABEL_MENU, "Clear", 200.0f, model::clearLabel, null, null);
        if (!fixedLabels) {
            extensible.addMenuItem(Label.LABEL_MENU, "Remove", 201.0f, model::removeLabel, null, null);
        }
    }

    private void renameLabel(Label label) {
        String oldName = label.name();
        String newName = JOptionPane.showInputDialog(this.extensible.dialogParent(), "Rename label \"" + oldName + "\" to:", oldName);
        if (newName == null) {
            return;
        }
        this.model.renameLabel(label, newName);
    }
}

