/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.actions;

import java.util.List;
import javax.swing.JOptionPane;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.labkit.Extensible;
import net.imglib2.labkit.MenuBar;
import net.imglib2.labkit.labeling.Label;
import net.imglib2.labkit.labeling.Labeling;
import net.imglib2.labkit.models.Holder;
import net.imglib2.labkit.models.ImageLabelingModel;
import net.imglib2.labkit.models.SegmentationItem;
import net.imglib2.labkit.models.SegmentationModel;
import net.imglib2.labkit.models.SegmentationResultsModel;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.view.Views;

public class SegmentationAsLabelAction {
    private final ImageLabelingModel labelingModel;
    private final Holder<? extends SegmentationItem> selectedSegmenter;

    public SegmentationAsLabelAction(Extensible extensible, SegmentationModel segmentationModel) {
        this.labelingModel = segmentationModel.imageLabelingModel();
        this.selectedSegmenter = segmentationModel.segmenterList().selectedSegmenter();
        extensible.addMenuItem(MenuBar.SEGMENTER_MENU, "Create Label from Segmentation ...", 400.0f, ignore -> this.addSegmentationAsLabels(), null, "");
        extensible.addMenuItem(SegmentationItem.SEGMENTER_MENU, "Create Label from Segmentation ...", 400.0f, this::addSegmentationAsLabel, null, null);
    }

    private void addSegmentationAsLabels() {
        this.addSegmentationAsLabel(this.selectedSegmenter.get());
    }

    private void addSegmentationAsLabel(SegmentationItem segmentationItem) {
        String selected;
        SegmentationResultsModel selectedResults = segmentationItem.results(this.labelingModel);
        List<String> labels = selectedResults.labels();
        int index = labels.indexOf(selected = (String)JOptionPane.showInputDialog(null, "Select label to be added", "Add Segmentation as Labels ...", -1, null, labels.toArray(), labels.get(labels.size() - 1)));
        if (index < 0) {
            return;
        }
        this.addLabel(selected, index, selectedResults.segmentation());
    }

    private void addLabel(String selected, int index, RandomAccessibleInterval<ShortType> segmentation) {
        Converter converter = (in, out) -> out.set(in.get() == index);
        RandomAccessibleInterval result = Converters.convert(segmentation, (Converter)converter, (Type)new BitType());
        Holder<Labeling> labelingHolder = this.labelingModel.labeling();
        SegmentationAsLabelAction.addLabel(labelingHolder.get(), "segmented " + selected, (RandomAccessibleInterval<BitType>)result);
        labelingHolder.notifier().notifyListeners();
    }

    private static void addLabel(Labeling labeling, String name, RandomAccessibleInterval<BitType> mask) {
        Cursor cursor = Views.iterable(mask).cursor();
        Label label = labeling.addLabel(name);
        RandomAccess<LabelingType<Label>> ra = labeling.randomAccess();
        while (cursor.hasNext()) {
            boolean value = ((BitType)cursor.next()).get();
            if (!value) continue;
            ra.setPosition((Localizable)cursor);
            ((LabelingType)ra.get()).add((Object)label);
        }
    }
}

