/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.actions;

import io.scif.FormatException;
import io.scif.img.ImgIOException;
import io.scif.img.ImgSaver;
import java.util.function.Function;
import javax.swing.JOptionPane;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.hdf5.HDF5Saver;
import net.imglib2.img.ImgView;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.labkit.Extensible;
import net.imglib2.labkit.actions.AbstractFileIoAction;
import net.imglib2.labkit.models.ImageLabelingModel;
import net.imglib2.labkit.models.SegmentationItem;
import net.imglib2.labkit.utils.ParallelUtils;
import net.imglib2.labkit.utils.progress.SwingProgressWriter;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;

public class SegmentationExportAction
extends AbstractFileIoAction {
    public SegmentationExportAction(Extensible extensible, ImageLabelingModel labelingModel) {
        super(extensible, AbstractFileIoAction.TIFF_FILTER, AbstractFileIoAction.HDF5_FILTER);
        this.addMenuItems(item -> item.results(labelingModel).segmentation(), "Segmentation Result");
        this.addMenuItems(item -> item.results(labelingModel).prediction(), "Probability Map");
    }

    private <T extends NumericType<T> & NativeType<T>> void addMenuItems(Function<SegmentationItem, RandomAccessibleInterval<T>> predictionFactory, String title) {
        this.initSaveAction(SegmentationItem.SEGMENTER_MENU, "Save " + title + " as TIF / HDF5 ...", 200.0f, (data, filename) -> this.saveImage(filename, (RandomAccessibleInterval)predictionFactory.apply((SegmentationItem)data)), "");
        this.extensible.addMenuItem(SegmentationItem.SEGMENTER_MENU, "Show " + title + " in ImageJ", 201.0f, data -> this.show((RandomAccessibleInterval)predictionFactory.apply((SegmentationItem)data)), null, "");
        this.extensible.addMenuItem(SegmentationItem.SEGMENTER_MENU, "Calculate entire " + title, 300.0f, item -> this.populate((RandomAccessibleInterval)predictionFactory.apply((SegmentationItem)item)), null, "");
    }

    private <T extends NumericType<T> & NativeType<T>> void populate(RandomAccessibleInterval<T> result) {
        ParallelUtils.runInOtherThread(() -> this.populate2(result));
    }

    private <T extends NumericType<T> & NativeType<T>> void populate2(RandomAccessibleInterval<T> result) {
        SwingProgressWriter progress = new SwingProgressWriter(null, "Segment Entire Image Volume");
        ParallelUtils.populateCachedImg(result, progress);
    }

    private <T extends NumericType<T> & NativeType<T>> void show(RandomAccessibleInterval<T> result) {
        this.populate(result);
        ParallelUtils.runInOtherThread(() -> ImageJFunctions.show((RandomAccessibleInterval)result));
    }

    private <T extends Type<T>> void saveImage(String filename, RandomAccessibleInterval<T> image) {
        if (filename.endsWith(".h5") || filename.endsWith(".xml")) {
            HDF5Saver saver = new HDF5Saver(image, filename);
            saver.setProgressWriter(new SwingProgressWriter(this.extensible.dialogParent(), "Save Image"));
            saver.writeAll();
        } else {
            try {
                ImgSaver saver = new ImgSaver(this.extensible.context());
                saver.saveImg(filename, ImgView.wrap(image, null));
            }
            catch (ImgIOException e) {
                if (e.getCause() instanceof FormatException) {
                    JOptionPane.showMessageDialog(null, "File format not supported:\n" + filename);
                }
                throw e;
            }
        }
    }
}

