/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.bdv;

import bdv.util.BdvSource;
import bdv.util.BdvStackSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerPanel;
import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;

public class BdvAutoContrast {
    public static void autoContrast(BdvSource bdvSource) {
        ValuePair<Double, Double> minMax = BdvAutoContrast.getMinMax(bdvSource);
        bdvSource.setDisplayRangeBounds(((Double)minMax.getA()).doubleValue(), ((Double)minMax.getB()).doubleValue());
        bdvSource.setDisplayRange(((Double)minMax.getA()).doubleValue(), ((Double)minMax.getB()).doubleValue());
    }

    private static ValuePair<Double, Double> getMinMax(BdvSource bdvSource) {
        ViewerPanel viewer = bdvSource.getBdvHandle().getViewerPanel();
        Source spimSource = ((SourceAndConverter)((BdvStackSource)bdvSource).getSources().get(0)).getSpimSource();
        int level = spimSource.getNumMipmapLevels() - 1;
        RandomAccessibleInterval source = spimSource.getSource(viewer.state().getCurrentTimepoint(), level);
        if (Util.getTypeFromInterval((Interval)source) instanceof RealType) {
            return BdvAutoContrast.getMinMaxForRealType((RandomAccessibleInterval)Cast.unchecked((Object)source));
        }
        return new ValuePair((Object)0.0, (Object)255.0);
    }

    private static ValuePair<Double, Double> getMinMaxForRealType(RandomAccessibleInterval<? extends RealType<?>> source) {
        double min;
        Cursor cursor = Views.iterable(source).cursor();
        if (!cursor.hasNext()) {
            return new ValuePair((Object)0.0, (Object)255.0);
        }
        long stepSize = Intervals.numElements(source) / 10000L + 1L;
        int randomLimit = (int)Math.min(Integer.MAX_VALUE, stepSize);
        Random random = new Random(42L);
        double max = min = ((RealType)cursor.next()).getRealDouble();
        while (cursor.hasNext()) {
            double value = ((RealType)cursor.get()).getRealDouble();
            cursor.jumpFwd(stepSize + (long)random.nextInt(randomLimit));
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        return new ValuePair((Object)min, (Object)max);
    }
}

