/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.bdv;

import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import bdv.viewer.Source;
import java.util.Objects;
import mpicbg.spim.data.generic.AbstractSpimData;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.labkit.bdv.ImgPlusBdvShowable;
import net.imglib2.labkit.bdv.SimpleBdvShowable;
import net.imglib2.labkit.bdv.SourceBdvShowable;
import net.imglib2.labkit.bdv.SpimBdvShowable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;

public interface BdvShowable {
    public static BdvShowable wrap(RandomAccessibleInterval<? extends NumericType<?>> image) {
        return BdvShowable.wrap(image, new AffineTransform3D());
    }

    public static BdvShowable wrap(RandomAccessibleInterval<? extends NumericType<?>> image, AffineTransform3D transformation) {
        return new SimpleBdvShowable(Objects.requireNonNull(image), transformation);
    }

    public static BdvShowable wrap(ImgPlus<? extends NumericType<?>> image) {
        return new ImgPlusBdvShowable(image);
    }

    public static BdvShowable wrap(AbstractSpimData<?> spimData) {
        return new SpimBdvShowable(Objects.requireNonNull(spimData));
    }

    public static BdvShowable wrap(Source<? extends NumericType<?>> source) {
        return new SourceBdvShowable(source);
    }

    public Interval interval();

    public AffineTransform3D transformation();

    public BdvStackSource<?> show(String var1, BdvOptions var2);
}

