/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.bdv;

import bdv.util.AxisOrder;
import bdv.util.BdvFunctions;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Interval;
import net.imglib2.labkit.bdv.BdvShowable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;

class ImgPlusBdvShowable
implements BdvShowable {
    private final ImgPlus<? extends NumericType<?>> image;

    ImgPlusBdvShowable(ImgPlus<? extends NumericType<?>> image) {
        this.image = image;
    }

    @Override
    public Interval interval() {
        return this.image;
    }

    @Override
    public AffineTransform3D transformation() {
        AffineTransform3D transform = new AffineTransform3D();
        transform.set(this.getCalibration(Axes.X), 0.0, 0.0, 0.0, 0.0, this.getCalibration(Axes.Y), 0.0, 0.0, 0.0, 0.0, this.getCalibration(Axes.Z), 0.0);
        return transform;
    }

    @Override
    public BdvStackSource<?> show(String title, BdvOptions options) {
        String name = this.image.getName();
        BdvOptions options1 = options.axisOrder(this.getAxisOrder()).sourceTransform(this.transformation());
        return BdvFunctions.show(this.image, (String)(name == null ? title : name), (BdvOptions)options1);
    }

    private AxisOrder getAxisOrder() {
        String code = IntStream.range(0, this.image.numDimensions()).mapToObj(i -> ((CalibratedAxis)this.image.axis(i)).type().getLabel().substring(0, 1)).collect(Collectors.joining());
        try {
            return AxisOrder.valueOf((String)code);
        }
        catch (IllegalArgumentException e) {
            return AxisOrder.DEFAULT;
        }
    }

    private double getCalibration(AxisType axisType) {
        int d = this.image.dimensionIndex(axisType);
        if (d == -1) {
            return 1.0;
        }
        return ((CalibratedAxis)this.image.axis(d)).averageScale((double)this.image.min(d), (double)this.image.max(d));
    }
}

