/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.brush;

import bdv.util.Affine3DHelpers;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.ViewerPanel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import net.imglib2.labkit.labeling.Label;
import net.imglib2.labkit.models.LabelingModel;
import net.imglib2.realtransform.AffineTransform3D;

public class BrushOverlay
implements OverlayRenderer {
    private final ViewerPanel viewer;
    private final LabelingModel model;
    private int x;
    private int y;
    private double radius = 5.0;
    private boolean visible = false;
    private boolean fontVisible = true;
    final AffineTransform3D viewerTransform = new AffineTransform3D();

    public BrushOverlay(ViewerPanel viewer, LabelingModel model) {
        this.viewer = viewer;
        this.model = model;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setFontVisible(boolean visible) {
        this.fontVisible = visible;
    }

    public void requestRepaint() {
        this.viewer.getDisplay().repaint();
    }

    public void drawOverlays(Graphics g) {
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setComposite(AlphaComposite.SrcOver);
            int roundScaledRadius = (int)Math.round(this.getScale() * this.radius);
            Label label = this.model.selectedLabel().get();
            if (label != null) {
                Color color = new Color(label.color().get());
                String title = label.name();
                if (this.fontVisible) {
                    this.drawTitle(g2d, color, title, roundScaledRadius);
                }
                this.drawCircle(g2d, color, roundScaledRadius);
            }
        }
    }

    public void setCanvasSize(int width, int height) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getScale() {
        ViewerPanel viewerPanel = this.viewer;
        synchronized (viewerPanel) {
            this.viewer.state().getViewerTransform(this.viewerTransform);
            return Affine3DHelpers.extractScale((AffineTransform3D)this.viewerTransform, (int)0);
        }
    }

    private void drawCircle(Graphics2D g2d, Color color, int roundScaledRadius) {
        g2d.setColor(color);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawOval(this.x - roundScaledRadius, this.y - roundScaledRadius, 2 * roundScaledRadius + 1, 2 * roundScaledRadius + 1);
    }

    private void drawTitle(Graphics2D g2d, Color color, String title, int roundScaledRadius) {
        g2d.setColor(color);
        g2d.drawString(title, this.x + roundScaledRadius + 20, this.y + roundScaledRadius + 20);
    }
}

