/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.brush;

import bdv.viewer.ViewerPanel;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import net.imglib2.Point;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.labkit.ActionsAndBehaviours;
import net.imglib2.labkit.brush.FloodFill;
import net.imglib2.labkit.labeling.Label;
import net.imglib2.labkit.models.LabelingModel;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.view.Views;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.RunnableAction;

public class FloodFillController {
    private static final double[] PIXEL_CENTER_OFFSET = new double[]{0.5, 0.5, 0.5};
    private final ViewerPanel viewer;
    private final LabelingModel model;
    private boolean overlapping = false;
    private final FloodFillClick floodFillBehaviour = new FloodFillClick(() -> {
        Label selected = this.selectedLabel();
        if (this.overlapping) {
            return l -> l.add(selected);
        }
        Collection<Label> visible = this.visibleLabels();
        return l -> {
            l.removeAll(visible);
            l.add(selected);
        };
    });
    private final FloodFillClick floodEraseBehaviour = new FloodFillClick(() -> {
        if (this.overlapping) {
            Label selected = this.selectedLabel();
            return l -> l.remove(selected);
        }
        Collection<Label> visible = this.visibleLabels();
        return l -> l.removeAll(visible);
    });

    private Collection<Label> visibleLabels() {
        return this.model.labeling().get().getLabels().stream().filter(Label::isVisible).collect(Collectors.toList());
    }

    public FloodFillController(ViewerPanel viewer, LabelingModel model, ActionsAndBehaviours behaviors) {
        this.viewer = viewer;
        this.model = model;
        RunnableAction nop = new RunnableAction("nop", () -> {});
        nop.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("F"));
        behaviors.addAction((AbstractNamedAction)nop);
        behaviors.addBehaviour((Behaviour)this.floodFillBehaviour, "floodfill", "F button1");
        behaviors.addBehaviour((Behaviour)this.floodEraseBehaviour, "floodclear", "R button1", "F button2", "F button3");
    }

    private Label selectedLabel() {
        return this.model.selectedLabel().get();
    }

    public ClickBehaviour floodEraseBehaviour() {
        return this.floodEraseBehaviour;
    }

    public ClickBehaviour floodFillBehaviour() {
        return this.floodFillBehaviour;
    }

    private RealPoint displayToImageCoordinates(int x, int y) {
        RealPoint labelLocation = new RealPoint(3);
        labelLocation.setPosition(x, 0);
        labelLocation.setPosition(y, 1);
        labelLocation.setPosition(0, 2);
        this.viewer.displayToGlobalCoordinates((RealLocalizable)labelLocation);
        this.model.labelTransformation().applyInverse((RealPositionable)labelLocation, (RealLocalizable)labelLocation);
        labelLocation.move(PIXEL_CENTER_OFFSET);
        return labelLocation;
    }

    public void setOverlapping(boolean override) {
        this.overlapping = override;
    }

    private RandomAccessibleInterval<LabelingType<Label>> labeling() {
        RandomAccessibleInterval label = this.model.labeling().get();
        if (this.model.isTimeSeries()) {
            return Views.hyperSlice((RandomAccessibleInterval)label, (int)(label.numDimensions() - 1), (long)this.viewer.state().getCurrentTimepoint());
        }
        return label;
    }

    private class FloodFillClick
    implements ClickBehaviour {
        private final Supplier<Consumer<Set<Label>>> operationFactory;

        FloodFillClick(Supplier<Consumer<Set<Label>>> operationFactory) {
            this.operationFactory = operationFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void floodFill(RealLocalizable coords) {
            ViewerPanel viewerPanel = FloodFillController.this.viewer;
            synchronized (viewerPanel) {
                RandomAccessibleInterval labeling1 = FloodFillController.this.labeling();
                Point seed = this.roundAndReduceDimension(coords, labeling1.numDimensions());
                FloodFill.doFloodFillOnActiveLabels((RandomAccessibleInterval<LabelingType<Label>>)labeling1, seed, this.operationFactory.get());
            }
        }

        private Point roundAndReduceDimension(RealLocalizable realLocalizable, int numDimesions) {
            Point point = new Point(numDimesions);
            for (int i = 0; i < point.numDimensions(); ++i) {
                point.setPosition((long)realLocalizable.getDoublePosition(i), i);
            }
            return point;
        }

        public void click(int x, int y) {
            this.floodFill((RealLocalizable)FloodFillController.this.displayToImageCoordinates(x, y));
            FloodFillController.this.model.dataChangedNotifier().notifyListeners(null);
        }
    }
}

