/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.brush;

import bdv.util.Affine3DHelpers;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.ViewerPanel;
import java.awt.Cursor;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.labkit.ActionsAndBehaviours;
import net.imglib2.labkit.brush.BrushOverlay;
import net.imglib2.labkit.brush.neighborhood.IterableRegionAsNeighborhood;
import net.imglib2.labkit.brush.neighborhood.TransformedSphere;
import net.imglib2.labkit.labeling.Label;
import net.imglib2.labkit.models.LabelingModel;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.Type;
import net.imglib2.util.LinAlgHelpers;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.ScrollBehaviour;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.RunnableAction;

public class LabelBrushController {
    private final ViewerPanel viewer;
    private final LabelingModel model;
    private final BrushOverlay brushOverlay;
    private final MoveBrush moveBrushBehaviour = new MoveBrush();
    private final PaintBehavior paintBehavior = new PaintBehavior(true);
    private final PaintBehavior eraseBehavior = new PaintBehavior(false);
    private double brushRadius = 1.0;
    private boolean overlapping = false;

    public LabelBrushController(ViewerPanel viewer, LabelingModel model, ActionsAndBehaviours behaviors) {
        this.viewer = viewer;
        this.brushOverlay = new BrushOverlay(viewer, model);
        this.model = model;
        this.brushOverlay.setRadius((int)this.getTransformedBrushRadius());
        viewer.getDisplay().addOverlayRenderer((OverlayRenderer)this.brushOverlay);
        this.installDefaultBehaviors(behaviors);
    }

    private void installDefaultBehaviors(ActionsAndBehaviours behaviors) {
        behaviors.addBehaviour((Behaviour)this.paintBehaviour(), "paint", "D button1", "SPACE button1");
        RunnableAction nop = new RunnableAction("nop", () -> {});
        nop.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("F"));
        behaviors.addAction((AbstractNamedAction)nop);
        behaviors.addBehaviour((Behaviour)this.eraseBehaviour(), "erase", "E button1", "SPACE button2", "SPACE button3");
        behaviors.addBehaviour((Behaviour)new ChangeBrushRadius(), "change brush radius", "D scroll", "E scroll", "SPACE scroll");
        behaviors.addBehaviour((Behaviour)this.drawBrushBehaviour(), "move brush", "E", "D", "SPACE");
    }

    public DragBehaviour drawBrushBehaviour() {
        return this.moveBrushBehaviour;
    }

    public DragBehaviour paintBehaviour() {
        return this.paintBehavior;
    }

    public DragBehaviour eraseBehaviour() {
        return this.eraseBehavior;
    }

    public void setBrushRadius(double brushRadius) {
        this.brushRadius = brushRadius;
        this.brushOverlay.setRadius(this.getTransformedBrushRadius());
        this.brushOverlay.requestRepaint();
    }

    public double getBrushRadius() {
        return this.brushRadius;
    }

    public void setOverlapping(boolean overlapping) {
        this.overlapping = overlapping;
    }

    private void makeLabelVisible() {
        Label label = this.model.selectedLabel().get();
        if (label == null) {
            return;
        }
        if (label.isVisible() && this.model.labelingVisibility().get().booleanValue()) {
            return;
        }
        label.setVisible(true);
        this.model.labelingVisibility().set(true);
        this.model.labeling().notifier().notifyListeners();
    }

    private double getTransformedBrushRadius() {
        return this.brushRadius * this.getScale(this.model.labelTransformation());
    }

    private double getScale(AffineTransform3D transformation) {
        return Affine3DHelpers.extractScale((AffineTransform3D)transformation, (int)0);
    }

    private RandomAccessibleInterval<LabelingType<Label>> slice() {
        RandomAccessibleInterval slice = this.model.labeling().get();
        if (this.model.isTimeSeries()) {
            return Views.hyperSlice((RandomAccessibleInterval)slice, (int)(slice.numDimensions() - 1), (long)this.viewer.state().getCurrentTimepoint());
        }
        return slice;
    }

    private void fireBitmapChanged(RealPoint a, RealPoint b, double radius) {
        long[] min = new long[2];
        long[] max = new long[2];
        for (int d = 0; d < 2; ++d) {
            min[d] = (long)(Math.min(a.getDoublePosition(d), b.getDoublePosition(d)) - radius);
            max[d] = (long)(Math.ceil(Math.max(a.getDoublePosition(d), b.getDoublePosition(d))) + radius);
        }
        this.model.dataChangedNotifier().notifyListeners((Interval)new FinalInterval(min, max));
    }

    private class MoveBrush
    implements DragBehaviour {
        private MoveBrush() {
        }

        public void init(int x, int y) {
            LabelBrushController.this.brushOverlay.setPosition(x, y);
            LabelBrushController.this.brushOverlay.setVisible(true);
            LabelBrushController.this.viewer.setCursor(Cursor.getPredefinedCursor(1));
            LabelBrushController.this.brushOverlay.requestRepaint();
        }

        public void drag(int x, int y) {
            LabelBrushController.this.brushOverlay.setPosition(x, y);
        }

        public void end(int x, int y) {
            LabelBrushController.this.brushOverlay.setVisible(false);
            LabelBrushController.this.viewer.setCursor(Cursor.getPredefinedCursor(0));
            LabelBrushController.this.brushOverlay.requestRepaint();
        }
    }

    private class ChangeBrushRadius
    implements ScrollBehaviour {
        private ChangeBrushRadius() {
        }

        public void scroll(double wheelRotation, boolean isHorizontal, int x, int y) {
            if (!isHorizontal) {
                int sign = wheelRotation < 0.0 ? 1 : -1;
                double distance = Math.max(1.0, LabelBrushController.this.brushRadius * 0.1);
                LabelBrushController.this.setBrushRadius(Math.min(Math.max(1.0, LabelBrushController.this.brushRadius + (double)sign * distance), 50.0));
            }
        }
    }

    private class PaintBehavior
    implements DragBehaviour {
        private boolean value;
        private RealPoint before;

        public PaintBehavior(boolean value) {
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(RealLocalizable coords) {
            ViewerPanel viewerPanel = LabelBrushController.this.viewer;
            synchronized (viewerPanel) {
                RandomAccessible<LabelingType<Label>> extended = this.extendLabelingType((RandomAccessibleInterval<LabelingType<Label>>)LabelBrushController.this.slice());
                double brushWidth = this.brushSizeInScreenPixel();
                AffineTransform3D D = this.brushMatrix(coords, brushWidth, brushWidth);
                AffineTransform3D m = this.displayToImageTransformation();
                m.concatenate(D);
                IterableRegionAsNeighborhood neighborhood = TransformedSphere.asNeighborhood(new long[3], m, extended.randomAccess());
                neighborhood.forEach(this.pixelOperation());
            }
        }

        private double brushSizeInScreenPixel() {
            return LabelBrushController.this.getTransformedBrushRadius() * LabelBrushController.this.getScale(this.viewerTransformation());
        }

        private Consumer<LabelingType<Label>> pixelOperation() {
            Label label = LabelBrushController.this.model.selectedLabel().get();
            if (this.value) {
                if (label != null) {
                    if (LabelBrushController.this.overlapping) {
                        return pixel -> pixel.add((Object)label);
                    }
                    List<Label> visibleLabels = this.getVisibleLabels();
                    return pixel -> {
                        pixel.removeAll((Collection)visibleLabels);
                        pixel.add((Object)label);
                    };
                }
                return pixel -> {};
            }
            if (LabelBrushController.this.overlapping && label != null) {
                return pixel -> pixel.remove((Object)label);
            }
            List<Label> visibleLabels = this.getVisibleLabels();
            return pixel -> pixel.removeAll((Collection)visibleLabels);
        }

        private List<Label> getVisibleLabels() {
            List<Label> visibleLabels = LabelBrushController.this.model.labeling().get().getLabels().stream().filter(Label::isVisible).collect(Collectors.toList());
            return visibleLabels;
        }

        private RandomAccessible<LabelingType<Label>> extendLabelingType(RandomAccessibleInterval<LabelingType<Label>> slice) {
            LabelingType variable = ((LabelingType)Util.getTypeFromInterval(slice)).createVariable();
            variable.clear();
            return Views.extendValue(slice, (Type)variable);
        }

        private AffineTransform3D brushMatrix(RealLocalizable coords, double brushWidth, double brushDepth) {
            AffineTransform3D D = new AffineTransform3D();
            D.set(brushWidth, 0.0, 0.0, coords.getDoublePosition(0), 0.0, brushWidth, 0.0, coords.getDoublePosition(1), 0.0, 0.0, brushDepth, 0.0);
            return D;
        }

        private AffineTransform3D displayToImageTransformation() {
            AffineTransform3D m = new AffineTransform3D();
            m.concatenate(LabelBrushController.this.model.labelTransformation().inverse());
            m.concatenate(this.viewerTransformation().inverse());
            return m;
        }

        private AffineTransform3D viewerTransformation() {
            AffineTransform3D t = new AffineTransform3D();
            LabelBrushController.this.viewer.state().getViewerTransform(t);
            return t;
        }

        private void paint(RealLocalizable a, RealLocalizable b) {
            long distance = (long)this.distance(a, b) + 1L;
            double step = Math.max(LabelBrushController.this.brushRadius * 0.5, 1.0);
            long i = 0L;
            while (i < distance) {
                this.paint(this.interpolate((double)i / (double)distance, a, b));
                i = (long)((double)i + step);
            }
        }

        RealLocalizable interpolate(double ratio, RealLocalizable a, RealLocalizable b) {
            RealPoint result = new RealPoint(a.numDimensions());
            for (int d = 0; d < result.numDimensions(); ++d) {
                result.setPosition(ratio * a.getDoublePosition(d) + (1.0 - ratio) * b.getDoublePosition(d), d);
            }
            return result;
        }

        double distance(RealLocalizable a, RealLocalizable b) {
            return LinAlgHelpers.distance((double[])this.asArray(a), (double[])this.asArray(b));
        }

        private double[] asArray(RealLocalizable a) {
            double[] result = new double[a.numDimensions()];
            a.localize(result);
            return result;
        }

        public void init(int x, int y) {
            RealPoint coords;
            LabelBrushController.this.makeLabelVisible();
            this.before = coords = new RealPoint(new float[]{x, y});
            this.paint((RealLocalizable)coords);
            LabelBrushController.this.brushOverlay.setPosition(x, y);
            LabelBrushController.this.brushOverlay.setFontVisible(false);
            LabelBrushController.this.fireBitmapChanged(coords, coords, this.brushSizeInScreenPixel());
        }

        public void drag(int x, int y) {
            RealPoint coords = new RealPoint(new float[]{x, y});
            this.paint((RealLocalizable)this.before, (RealLocalizable)coords);
            LabelBrushController.this.fireBitmapChanged(this.before, coords, this.brushSizeInScreenPixel());
            this.before = coords;
            LabelBrushController.this.brushOverlay.setPosition(x, y);
        }

        public void end(int x, int y) {
            LabelBrushController.this.brushOverlay.setFontVisible(true);
        }
    }
}

