/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.brush.neighborhood;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Point;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.labkit.brush.neighborhood.MappingCursor;
import net.imglib2.roi.IterableRegion;
import net.imglib2.type.logic.BitType;

public class IterableRegionAsNeighborhood<T>
extends Point
implements Neighborhood<T> {
    private final RandomAccess<T> source;
    private final IterableRegion<BitType> region;

    public IterableRegionAsNeighborhood(IterableRegion<BitType> region, RandomAccess<T> source) {
        super(source.numDimensions());
        this.source = source;
        this.region = region;
    }

    public Interval getStructuringElementBoundingBox() {
        return this.region;
    }

    public Cursor<T> cursor() {
        return new MappingCursor(this.position, this.region.cursor(), this.source.copyRandomAccess());
    }

    public Cursor<T> localizingCursor() {
        return this.cursor();
    }

    public long size() {
        return this.region.size();
    }

    public T firstElement() {
        return (T)this.cursor().next();
    }

    public Object iterationOrder() {
        return this;
    }

    public Iterator<T> iterator() {
        return this.cursor();
    }

    public long min(int d) {
        return this.region.min(d) + this.position[d];
    }

    public void min(long[] min) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            min[d] = this.min(d);
        }
    }

    public void min(Positionable min) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            min.setPosition(this.min(d), d);
        }
    }

    public long max(int d) {
        return this.region.max(d) + this.position[d];
    }

    public void max(long[] max) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            max[d] = this.max(d);
        }
    }

    public void max(Positionable max) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            max.setPosition(this.max(d), d);
        }
    }

    public void dimensions(long[] dimensions) {
        this.region.dimensions(dimensions);
    }

    public long dimension(int d) {
        return this.region.dimension(d);
    }

    public double realMin(int d) {
        return this.region.realMin(d) + (double)this.position[d];
    }

    public void realMin(double[] min) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            min[d] = this.realMin(d);
        }
    }

    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            min.setPosition(this.realMin(d), d);
        }
    }

    public double realMax(int d) {
        return this.region.realMax(d) + (double)this.position[d];
    }

    public void realMax(double[] max) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            max[d] = this.realMax(d);
        }
    }

    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            max.setPosition(this.realMax(d), d);
        }
    }
}

