/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.brush.neighborhood;

import java.util.Arrays;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.labkit.brush.neighborhood.IterableRegionAsNeighborhood;
import net.imglib2.labkit.brush.neighborhood.RealPoints;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.roi.IterableRegion;
import net.imglib2.sparse.SparseIterableRegion;
import net.imglib2.type.logic.BitType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class TransformedSphere {
    private final AffineTransform3D transform;

    public TransformedSphere(AffineTransform3D transform) {
        this.transform = transform;
    }

    public boolean contains(RealLocalizable point) {
        RealPoint out = new RealPoint(3);
        this.transform.applyInverse((RealPositionable)out, point);
        return RealPoints.squaredLength((RealLocalizable)out) <= 1.0;
    }

    public RealInterval realBoundingBox() {
        double[] min = new double[3];
        double[] max = new double[3];
        for (int d = 0; d < 3; ++d) {
            double halfLength = Math.abs(this.transform.get(d, 0)) + Math.abs(this.transform.get(d, 1)) + Math.abs(this.transform.get(d, 2));
            double center = this.transform.get(d, 3);
            min[d] = center - halfLength;
            max[d] = center + halfLength;
        }
        return new FinalRealInterval(min, max);
    }

    public Interval boundingBox() {
        RealInterval boundingBox = this.realBoundingBox();
        long[] min = new long[boundingBox.numDimensions()];
        long[] max = new long[boundingBox.numDimensions()];
        for (int d = 0; d < boundingBox.numDimensions(); ++d) {
            min[d] = (long)Math.floor(boundingBox.realMin(d));
            max[d] = (long)Math.ceil(boundingBox.realMax(d));
        }
        return new FinalInterval(min, max);
    }

    public static <T> IterableRegionAsNeighborhood<T> asNeighborhood(long[] position, AffineTransform3D transformation, RandomAccess<T> source) {
        TransformedSphere sphere = new TransformedSphere(transformation);
        IterableRegion<BitType> region = TransformedSphere.iterableRegion(sphere, source.numDimensions());
        IterableRegionAsNeighborhood<T> neighborhood = new IterableRegionAsNeighborhood<T>(region, source);
        neighborhood.setPosition(position);
        return neighborhood;
    }

    static IterableRegion<BitType> iterableRegion(TransformedSphere sphere, int numDimensions) {
        return TransformedSphere.iterableRegion(sphere, TransformedSphere.intervalChangeNumDimensions(sphere.boundingBox(), numDimensions));
    }

    private static Interval intervalChangeNumDimensions(Interval interval, int numDimensions) {
        long[] min = Arrays.copyOf(Intervals.minAsLongArray((Interval)interval), numDimensions);
        long[] max = Arrays.copyOf(Intervals.maxAsLongArray((Interval)interval), numDimensions);
        return new FinalInterval(min, max);
    }

    private static IterableRegion<BitType> iterableRegion(TransformedSphere sphere, Interval interval) {
        SparseIterableRegion result = new SparseIterableRegion(interval);
        Cursor cursor = Views.flatIterable(TransformedSphere.adoptToDimension(result, 3)).cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((BitType)cursor.get()).set(sphere.contains((RealLocalizable)cursor));
        }
        return result;
    }

    private static <T> RandomAccessibleInterval<T> adoptToDimension(RandomAccessibleInterval<T> result, int numDimension) {
        while (result.numDimensions() < numDimension) {
            result = Views.addDimension(result, (long)0L, (long)0L);
        }
        if (result.numDimensions() > numDimension) {
            throw new UnsupportedOperationException();
        }
        return result;
    }
}

