/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.inputimage;

import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.labkit.bdv.BdvShowable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;

class ContrastUtils {
    ContrastUtils() {
    }

    public static double getMin(ImgPlus<?> image) {
        double value;
        double min = 0.0;
        int i = 0;
        while (!Double.isNaN(value = image.getChannelMinimum(i))) {
            min = Math.min(value, min);
            ++i;
        }
        return min;
    }

    public static double getMax(ImgPlus<? extends NumericType<?>> image) {
        double value;
        double max = 0.0;
        int i = 0;
        while (!Double.isNaN(value = image.getChannelMaximum(i))) {
            max = Math.max(value, max);
            ++i;
        }
        return max;
    }

    public static BdvShowable showableAddSetDisplayRange(final BdvShowable wrap, final double min, final double max) {
        return new BdvShowable(){

            @Override
            public Interval interval() {
                return wrap.interval();
            }

            @Override
            public AffineTransform3D transformation() {
                return wrap.transformation();
            }

            @Override
            public BdvStackSource<?> show(String title, BdvOptions options) {
                BdvStackSource<?> result = wrap.show(title, options);
                result.setDisplayRange(min, max);
                return result;
            }
        };
    }
}

