/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.inputimage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.Axis;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.TypedAxis;
import net.imglib2.img.display.imagej.ImgPlusViews;

public class ImgPlusViewsOld {
    public static <T> ImgPlus<T> sortAxes(ImgPlus<T> in, List<AxisType> order) {
        if (in.numDimensions() == 0) {
            return in;
        }
        boolean changend = true;
        while (changend) {
            changend = false;
            for (int i = 0; i < in.numDimensions() - 1; ++i) {
                if (order.indexOf(((CalibratedAxis)in.axis(i)).type()) <= order.indexOf(((CalibratedAxis)in.axis(i + 1)).type())) continue;
                in = ImgPlusViews.permute(in, (int)i, (int)(i + 1));
                changend = true;
            }
        }
        return in;
    }

    public static <T> ImgPlus<T> fixAxes(ImgPlus<T> in, List<AxisType> allowed) {
        List<AxisType> newAxisTypes = ImgPlusViewsOld.fixAxes(ImgPlusViewsOld.getAxes(in), allowed);
        CalibratedAxis[] newAxes = (CalibratedAxis[])IntStream.range(0, in.numDimensions()).mapToObj(i -> {
            CalibratedAxis newAxis = ((CalibratedAxis)in.axis(i)).copy();
            newAxis.setType((AxisType)newAxisTypes.get(i));
            return newAxis;
        }).toArray(CalibratedAxis[]::new);
        return new ImgPlus(in.getImg(), in.getName(), newAxes);
    }

    private static List<AxisType> fixAxes(List<AxisType> in, List<AxisType> allowed) {
        ArrayList<AxisType> unusedAxis = new ArrayList<AxisType>(allowed);
        unusedAxis.removeAll(in);
        Predicate isDuplicate = ImgPlusViewsOld.createIsDuplicatePredicate();
        Predicate<AxisType> replaceIf = axis -> isDuplicate.test(axis) || !allowed.contains(axis);
        Iterator iterator = unusedAxis.iterator();
        Supplier<AxisType> replacements = () -> iterator.hasNext() ? (AxisType)iterator.next() : Axes.unknown();
        return ImgPlusViewsOld.replaceMatches(in, replaceIf, replacements);
    }

    public static List<AxisType> getAxes(ImgPlus<?> in) {
        return IntStream.range(0, in.numDimensions()).mapToObj(arg_0 -> in.axis(arg_0)).map(TypedAxis::type).collect(Collectors.toList());
    }

    private static <T> Predicate<T> createIsDuplicatePredicate() {
        HashSet before = new HashSet();
        return element -> {
            boolean isDuplicate = before.contains(element);
            if (!isDuplicate) {
                before.add(element);
            }
            return isDuplicate;
        };
    }

    private static <T> List<T> replaceMatches(List<T> in, Predicate<T> predicate, Supplier<T> replacements) {
        return in.stream().map(value -> predicate.test(value) ? replacements.get() : value).collect(Collectors.toList());
    }

    public static boolean hasAxis(ImgPlus<?> image, AxisType axes) {
        return image.dimensionIndex(axes) >= 0;
    }

    public static List<CalibratedAxis> getCalibratedAxes(ImgPlus<?> image) {
        CalibratedAxis[] axes = new CalibratedAxis[image.numDimensions()];
        image.axes((Axis[])axes);
        return Arrays.asList(axes);
    }

    public static long getDimension(ImgPlus<?> image, AxisType axis) {
        return image.dimension(image.dimensionIndex(axis));
    }

    public static int numberOfSpatialDimensions(ImgPlus<?> imgPlus) {
        int n = 0;
        for (AxisType axes : ImgPlusViewsOld.getAxes(imgPlus)) {
            if (!axes.isSpatial()) continue;
            ++n;
        }
        return n;
    }

    public static <T> ImgPlus<T> hyperSlice(ImgPlus<T> image, AxisType axis, long position) {
        int d = image.dimensionIndex(axis);
        if (d < 0) {
            return image;
        }
        return ImgPlusViews.hyperSlice(image, (int)d, (long)position);
    }

    public static <T> List<ImgPlus<?>> hyperSlices(ImgPlus<T> image, AxisType axis) {
        int d = image.dimensionIndex(axis);
        if (d < 0) {
            return Collections.singletonList(image);
        }
        return LongStream.rangeClosed(image.min(d), image.max(d)).mapToObj(position -> ImgPlusViewsOld.hyperSlice(image, axis, position)).collect(Collectors.toList());
    }
}

