/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.inputimage;

import bdv.img.imaris.Imaris;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import java.io.IOException;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import net.imagej.ImgPlus;
import net.imglib2.labkit.bdv.BdvShowable;
import net.imglib2.labkit.inputimage.InputImage;
import net.imglib2.labkit.inputimage.SpimDataToImgPlus;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Cast;
import org.apache.commons.io.FilenameUtils;

public class SpimDataInputImage
implements InputImage {
    private final AbstractSpimData<?> spimData;
    private final ImgPlus<? extends NumericType<?>> imageForSegmentation;
    private final String defaultLabelingFilename;

    public SpimDataInputImage(String filename, Integer level) {
        this.spimData = this.openSpimData(filename);
        this.imageForSegmentation = (ImgPlus)Cast.unchecked(SpimDataToImgPlus.wrap(this.spimData, level));
        this.imageForSegmentation.setName(FilenameUtils.getName((String)filename));
        this.defaultLabelingFilename = filename + ".labeling";
    }

    private SpimDataMinimal openSpimData(String filename) {
        try {
            if (filename.endsWith(".ims")) {
                return Imaris.openIms((String)filename);
            }
            return new XmlIoSpimDataMinimal().load(filename);
        }
        catch (IOException | SpimDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static SpimDataInputImage openWithGuiForLevelSelection(String filename) {
        return new SpimDataInputImage(filename, null);
    }

    @Override
    public BdvShowable showable() {
        return BdvShowable.wrap(this.spimData);
    }

    @Override
    public ImgPlus<? extends NumericType<?>> imageForSegmentation() {
        return this.imageForSegmentation;
    }

    @Override
    public String getDefaultLabelingFilename() {
        return this.defaultLabelingFilename;
    }
}

