/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.labeling;

import com.google.gson.annotations.JsonAdapter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.labkit.labeling.Label;
import net.imglib2.labkit.labeling.LabelingSerializer;
import net.imglib2.labkit.labeling.Labelings;
import net.imglib2.labkit.utils.ColorSupplier;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.sparse.SparseIterableRegion;
import net.imglib2.sparse.SparseRandomAccessIntType;
import net.imglib2.type.BooleanType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.Cast;
import net.imglib2.util.ConstantUtils;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

@JsonAdapter(value=LabelingSerializer.Adapter.class)
public class Labeling
extends AbstractWrappedInterval<Interval>
implements RandomAccessibleInterval<LabelingType<Label>> {
    private final ImgLabeling<Label, ?> imgLabeling;
    private List<Label> labels;
    private List<CalibratedAxis> axes;
    private ColorSupplier colorSupplier;

    public static Labeling createEmpty(List<String> labels, Interval interval) {
        Labeling result = Labeling.createEmptyLabels(Collections.emptyList(), interval);
        labels.forEach(result::addLabel);
        return result;
    }

    public static Labeling createEmptyLabels(List<Label> labels, Interval interval) {
        ImgLabeling imgLabeling = new ImgLabeling((RandomAccessibleInterval)new SparseRandomAccessIntType(interval));
        return new Labeling(labels, imgLabeling, new ColorSupplier());
    }

    public static Labeling fromImgLabeling(ImgLabeling<String, ?> imgLabeling) {
        ColorSupplier colors = new ColorSupplier();
        ImgLabeling<Label, ?> labelsImgLabeling = Labelings.mapLabels(imgLabeling, name -> new Label((String)name, colors.get()));
        return new Labeling(new ArrayList<Label>(labelsImgLabeling.getMapping().getLabels()), labelsImgLabeling, colors);
    }

    public static Labeling fromMap(Map<String, IterableRegion<BitType>> regions) {
        if (regions.isEmpty()) {
            throw new IllegalArgumentException("Labeling.fromMap: The given map must not be empty.");
        }
        ColorSupplier colors = new ColorSupplier();
        LinkedHashMap<Label, IterableRegion<BitType>> regions2 = new LinkedHashMap<Label, IterableRegion<BitType>>();
        for (Map.Entry<String, IterableRegion<BitType>> entry : regions.entrySet()) {
            regions2.put(new Label(entry.getKey(), colors.get()), entry.getValue());
        }
        ArrayList<Label> labels = new ArrayList<Label>(regions2.keySet());
        ImgLabeling<Label, ?> imgLabling = Labeling.initImgLabling(regions2);
        return new Labeling(labels, imgLabling, colors);
    }

    private static ImgLabeling<Label, ?> initImgLabling(Map<Label, IterableRegion<BitType>> regions) {
        Interval interval = Labeling.getInterval(regions.values());
        ImgLabeling imgLabeling = new ImgLabeling((RandomAccessibleInterval)new SparseRandomAccessIntType(interval));
        RandomAccess ra = imgLabeling.randomAccess();
        regions.forEach((label, region) -> {
            Cursor cursor = region.cursor();
            while (cursor.hasNext()) {
                cursor.fwd();
                ra.setPosition((Localizable)cursor);
                ((LabelingType)ra.get()).add(label);
            }
        });
        return imgLabeling;
    }

    private static Interval getInterval(Collection<? extends Interval> intervals) {
        FinalInterval result = new FinalInterval(intervals.iterator().next());
        for (Interval interval : intervals) {
            if (Intervals.equals((Interval)result, (Interval)interval)) continue;
            throw new IllegalArgumentException("Intervals must match");
        }
        return result;
    }

    private Labeling(List<Label> labels, ImgLabeling<Label, ?> labeling, ColorSupplier colorSupplier) {
        super(labeling);
        this.imgLabeling = labeling;
        this.labels = new ArrayList<Label>(labels);
        this.colorSupplier = colorSupplier;
        this.axes = this.initAxes(labeling.numDimensions());
    }

    private List<CalibratedAxis> initAxes(int i) {
        return IntStream.range(0, i).mapToObj(ignore -> new DefaultLinearAxis()).collect(Collectors.toList());
    }

    public Interval interval() {
        return new FinalInterval(this.imgLabeling);
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setAxes(List<CalibratedAxis> axes) {
        this.axes = axes.stream().map(CalibratedAxis::copy).collect(Collectors.toList());
    }

    public Label getLabel(String name) {
        for (Label label : this.labels) {
            if (!label.name().equals(name)) continue;
            return label;
        }
        throw new NoSuchElementException();
    }

    public RandomAccessibleInterval<BitType> getRegion(Label label) {
        return Labeling.slice(this.imgLabeling, label);
    }

    public Map<Label, IterableRegion<BitType>> iterableRegions() {
        Cursor<?> cursor = this.sparsityCursor();
        RandomAccess ra = this.imgLabeling.randomAccess();
        HashMap regions = new HashMap();
        this.labels.forEach(label -> regions.put(label, new SparseIterableRegion((Interval)this.imgLabeling)));
        while (cursor.hasNext()) {
            cursor.fwd();
            ra.setPosition(cursor);
            ((LabelingType)ra.get()).forEach(label -> ((SparseIterableRegion)((Object)((Object)regions.get(label)))).add((Localizable)cursor));
        }
        return Collections.unmodifiableMap(regions);
    }

    public Cursor<?> sparsityCursor() {
        RandomAccessibleInterval indexImg = this.imgLabeling.getIndexImg();
        if (indexImg instanceof SparseRandomAccessIntType) {
            return ((SparseRandomAccessIntType)indexImg).sparseCursor();
        }
        RandomAccessible voids = ConstantUtils.constantRandomAccessible(null, (int)this.imgLabeling.numDimensions());
        return Views.interval((RandomAccessible)voids, this.imgLabeling).cursor();
    }

    private static <T> RandomAccessibleInterval<BitType> slice(RandomAccessibleInterval<? extends Set<T>> labeling, T value) {
        Converter converter = (in, out) -> {
            SetEntryAsBitType modifyingBitType = (SetEntryAsBitType)((Object)out);
            modifyingBitType.setSet(in);
        };
        return Converters.convert(labeling, (Converter)converter, new SetEntryAsBitType<T>(value));
    }

    public RandomAccessibleInterval<? extends IntegerType<?>> getIndexImg() {
        return this.imgLabeling.getIndexImg();
    }

    public List<Set<Label>> getLabelSets() {
        final LabelingMapping mapping = this.imgLabeling.getMapping();
        return new AbstractList<Set<Label>>(){

            @Override
            public Set<Label> get(int index) {
                return mapping.labelsAtIndex(index);
            }

            @Override
            public int size() {
                return mapping.numSets();
            }
        };
    }

    public List<CalibratedAxis> axes() {
        return this.axes;
    }

    public Label addLabel(String label) {
        Objects.requireNonNull(label);
        Label e = new Label(label, this.colorSupplier.get());
        this.labels.add(e);
        return e;
    }

    public void addLabel(String newName, RandomAccessibleInterval<? extends BooleanType<?>> bitmap) {
        Label label = this.addLabel(newName);
        LoopBuilder.setImages(bitmap, (RandomAccessibleInterval)this).forEachPixel((i, o) -> {
            if (i.get()) {
                o.add((Object)label);
            }
        });
    }

    public void removeLabel(Label label) {
        if (!this.labels.contains(label)) {
            return;
        }
        this.labels.remove(label);
        this.clearLabel(label);
    }

    public void renameLabel(Label oldLabel, String newLabel) {
        oldLabel.setName(newLabel);
    }

    public void clearLabel(Label label) {
        Cursor<?> cursor = this.sparsityCursor();
        RandomAccess<LabelingType<Label>> ra = this.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            ra.setPosition(cursor);
            Set set = (Set)ra.get();
            set.remove(label);
        }
    }

    public void setLabelOrder(Comparator<? super Label> comparator) {
        this.labels.sort(comparator);
    }

    public RandomAccess<LabelingType<Label>> randomAccess() {
        return (RandomAccess)Cast.unchecked((Object)this.imgLabeling.randomAccess());
    }

    public RandomAccess<LabelingType<Label>> randomAccess(Interval interval) {
        return (RandomAccess)Cast.unchecked((Object)this.imgLabeling.randomAccess(interval));
    }

    public static class SetEntryAsBitType<T>
    extends BitType {
        private Set<T> set = null;
        private final T entry;

        public SetEntryAsBitType(T entry) {
            this.entry = entry;
        }

        public void setSet(Set<T> set) {
            this.set = set;
        }

        public BitType createVariable() {
            return this.copy();
        }

        public BitType copy() {
            return new SetEntryAsBitType<T>(this.entry);
        }

        public boolean get() {
            if (this.set == null) {
                return false;
            }
            return this.set.contains(this.entry);
        }

        public void set(boolean value) {
            if (this.set == null) {
                return;
            }
            if (value) {
                this.set.add(this.entry);
            } else {
                this.set.remove(this.entry);
            }
        }
    }
}

