/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.labeling;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.labkit.bdv.BdvLayer;
import net.imglib2.labkit.bdv.BdvShowable;
import net.imglib2.labkit.labeling.Label;
import net.imglib2.labkit.labeling.Labeling;
import net.imglib2.labkit.models.DefaultHolder;
import net.imglib2.labkit.models.Holder;
import net.imglib2.labkit.models.LabelingModel;
import net.imglib2.labkit.utils.ARGBVector;
import net.imglib2.labkit.utils.ParametricNotifier;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.IntegerType;

public class LabelsLayer
implements BdvLayer {
    private final LabelingModel model;
    private final Holder<BdvShowable> showable;
    private final ParametricNotifier<Interval> listeners = new ParametricNotifier();
    private final ARGBType BLACK = new ARGBType(0);

    public LabelsLayer(LabelingModel model) {
        this.model = model;
        this.showable = new DefaultHolder<BdvShowable>(BdvShowable.wrap(this.colorView(), model.labelTransformation()));
        model.labeling().notifier().addListener(this::updateView);
        model.dataChangedNotifier().addListener(interval -> this.listeners.notifyListeners((Interval)interval));
    }

    private void updateView() {
        this.showable.set(BdvShowable.wrap(this.colorView(), this.model.labelTransformation()));
        this.listeners.notifyListeners(null);
    }

    private RandomAccessibleInterval<ARGBType> colorView() {
        Labeling labeling = this.model.labeling().get();
        List<Set<Label>> labelSets = labeling.getLabelSets();
        TIntObjectHashMap colors = new TIntObjectHashMap();
        return Converters.convert(labeling.getIndexImg(), (arg_0, arg_1) -> this.lambda$colorView$1((TIntObjectMap)colors, labelSets, arg_0, arg_1), (Type)new ARGBType());
    }

    private ARGBType getColor(Set<Label> set) {
        List<Label> visible = set.stream().filter(Label::isVisible).collect(Collectors.toList());
        if (visible.isEmpty()) {
            return this.BLACK;
        }
        ARGBVector collector = new ARGBVector();
        visible.forEach(label -> collector.add(label.color()));
        collector.div(visible.size());
        return collector.get();
    }

    @Override
    public Holder<BdvShowable> image() {
        return this.showable;
    }

    @Override
    public ParametricNotifier<Interval> listeners() {
        return this.listeners;
    }

    @Override
    public Holder<Boolean> visibility() {
        return this.model.labelingVisibility();
    }

    @Override
    public String title() {
        return "Labeling";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$colorView$1(TIntObjectMap colors, List labelSets, IntegerType in, ARGBType out) {
        int i = in.getInteger();
        ARGBType c = (ARGBType)colors.get(i);
        if (c == null) {
            c = this.getColor((Set)labelSets.get(i));
            TIntObjectMap tIntObjectMap = colors;
            synchronized (tIntObjectMap) {
                colors.put(i, (Object)c);
            }
        }
        out.set(c);
    }
}

