/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.models;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.imagej.ImgPlus;
import net.imglib2.labkit.labeling.Labeling;
import net.imglib2.labkit.menu.MenuKey;
import net.imglib2.labkit.models.ImageLabelingModel;
import net.imglib2.labkit.models.SegmentationResultsModel;
import net.imglib2.labkit.segmentation.ForwardingSegmenter;
import net.imglib2.labkit.segmentation.SegmentationPlugin;
import net.imglib2.labkit.segmentation.Segmenter;
import net.imglib2.util.Pair;

public class SegmentationItem
extends ForwardingSegmenter {
    public static final MenuKey<SegmentationItem> SEGMENTER_MENU = new MenuKey<SegmentationItem>(SegmentationItem.class);
    private static final AtomicInteger counter = new AtomicInteger();
    private final String name;
    private String filename;
    private boolean modified;
    private final Map<ImageLabelingModel, SegmentationResultsModel> results;

    public SegmentationItem(SegmentationPlugin plugin) {
        super(plugin.createSegmenter());
        this.name = "#" + counter.incrementAndGet() + " - " + plugin.getTitle();
        this.results = new WeakHashMap<ImageLabelingModel, SegmentationResultsModel>();
        this.filename = null;
        this.modified = false;
    }

    @Deprecated
    public Segmenter segmenter() {
        return this;
    }

    public String name() {
        return this.name;
    }

    public SegmentationResultsModel results(ImageLabelingModel imageLabeling) {
        SegmentationResultsModel result = this.results.get(imageLabeling);
        if (result == null) {
            result = new SegmentationResultsModel(imageLabeling, this.getSourceSegmenter());
            this.results.put(imageLabeling, result);
        }
        return result;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public void openModel(String path) {
        super.openModel(path);
        this.filename = path;
        this.modified = false;
        this.results.forEach((i, r) -> r.update());
    }

    @Override
    public void train(List<Pair<ImgPlus<?>, Labeling>> data) {
        this.results.forEach((i, r) -> r.clear());
        this.modified = true;
        super.train(data);
        this.results.forEach((i, r) -> r.update());
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getFileName() {
        return this.filename;
    }
}

