/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.models;

import java.util.ArrayList;
import java.util.List;
import net.imagej.ImgPlus;
import net.imglib2.labkit.labeling.Labeling;
import net.imglib2.labkit.models.DefaultHolder;
import net.imglib2.labkit.models.Holder;
import net.imglib2.labkit.models.SegmentationItem;
import net.imglib2.labkit.segmentation.SegmentationPlugin;
import net.imglib2.util.Pair;
import org.scijava.Context;

public class SegmenterListModel {
    private final Context context;
    private final Holder<List<SegmentationItem>> segmenters = new DefaultHolder(new ArrayList());
    private final Holder<SegmentationItem> selectedSegmenter = new DefaultHolder<Object>(null);
    private final Holder<Boolean> segmentationVisibility = new DefaultHolder<Boolean>(true);
    private final Holder<List<Pair<ImgPlus<?>, Labeling>>> trainingData = new DefaultHolder<Object>(null);

    public SegmenterListModel(Context context) {
        this.context = context;
        this.segmenters.notifier().addListener(() -> {
            if (!this.segmenters.get().contains(this.selectedSegmenter.get())) {
                this.selectedSegmenter.set(null);
            }
        });
    }

    public Holder<List<SegmentationItem>> segmenters() {
        return this.segmenters;
    }

    public Holder<SegmentationItem> selectedSegmenter() {
        return this.selectedSegmenter;
    }

    public SegmentationItem addSegmenter(SegmentationPlugin plugin) {
        SegmentationItem segmentationItem = new SegmentationItem(plugin);
        this.segmenters.get().add(segmentationItem);
        this.segmenters.notifier().notifyListeners();
        return segmentationItem;
    }

    public void remove(SegmentationItem item) {
        this.segmenters.get().remove(item);
        this.segmenters.notifier().notifyListeners();
    }

    public Holder<Boolean> segmentationVisibility() {
        return this.segmentationVisibility;
    }

    public Context context() {
        return this.context;
    }

    public Holder<List<Pair<ImgPlus<?>, Labeling>>> trainingData() {
        return this.trainingData;
    }
}

