/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.models;

import bdv.viewer.ViewerPanel;
import java.util.Arrays;
import java.util.Collections;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.trainable_segmentation.RevampUtils;

public class TransformationModel {
    private final boolean isTimeSeries;
    private ViewerPanel viewerPanel;

    public TransformationModel(boolean isTimeSeries) {
        this.isTimeSeries = isTimeSeries;
    }

    public void initialize(ViewerPanel viewerPanel) {
        this.viewerPanel = viewerPanel;
    }

    private int width() {
        return this.viewerPanel == null ? 100 : this.viewerPanel.getWidth();
    }

    private int height() {
        return this.viewerPanel == null ? 100 : this.viewerPanel.getHeight();
    }

    private void setTransformation(AffineTransform3D transformation) {
        if (this.viewerPanel != null) {
            this.viewerPanel.setCurrentViewerTransform(transformation);
        }
    }

    public void transformToShowInterval(Interval interval, AffineTransform3D transformation) {
        if (this.isTimeSeries) {
            int lastDim = interval.numDimensions() - 1;
            long meanTimePoint = (interval.min(lastDim) + interval.max(lastDim)) / 2L;
            if (this.viewerPanel != null) {
                this.viewerPanel.setTimepoint((int)meanTimePoint);
            }
            interval = RevampUtils.removeLastDimension((Interval)interval);
        }
        double[] screenSize = new double[]{this.width(), this.height()};
        AffineTransform3D concat = new AffineTransform3D();
        concat.set(TransformationModel.getTransformation(interval, screenSize));
        concat.concatenate(transformation.inverse());
        this.setTransformation(concat);
    }

    private static AffineTransform3D getTransformation(Interval interval, double[] screenSize) {
        double scale = 0.5 * TransformationModel.getBiggestScaleFactor(screenSize, interval);
        double[] translate = TransformationModel.getTranslation(screenSize, interval, scale);
        AffineTransform3D transform = new AffineTransform3D();
        transform.scale(scale);
        transform.translate(translate);
        return transform;
    }

    private static double[] getTranslation(double[] screenSize, Interval labelBox, double labelScale) {
        double[] translate = new double[3];
        for (int i = 0; i < Math.min(translate.length, labelBox.numDimensions()); ++i) {
            translate[i] = (double)(-(labelBox.min(i) + labelBox.max(i))) * labelScale / 2.0;
            if (i >= 2) continue;
            int n = i;
            translate[n] = translate[n] + screenSize[i] / 2.0;
        }
        return translate;
    }

    private static double getBiggestScaleFactor(double[] screenSize, Interval labelBox) {
        Double[] scales = new Double[2];
        double minLength = 20.0;
        for (int i = 0; i < 2; ++i) {
            scales[i] = screenSize[i] / Math.max((double)(labelBox.max(i) - labelBox.min(i)), 20.0);
        }
        return Collections.min(Arrays.asList(scales));
    }
}

