/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.imglib2.labkit.models.SegmenterListModel;
import net.imglib2.labkit.segmentation.SegmentationPlugin;
import net.imglib2.labkit.segmentation.SegmentationPluginService;
import net.imglib2.trainable_segmentation.utils.SingletonContext;
import net.miginfocom.swing.MigLayout;
import org.scijava.Context;

public class AddSegmenterPanel
extends JPanel {
    public AddSegmenterPanel(SegmenterListModel segmenterListModel) {
        this.setLayout(new BorderLayout());
        JPanel list = new JPanel((LayoutManager)new MigLayout("", "[grow]"));
        list.setBackground(UIManager.getColor("List.background"));
        list.add((Component)new JLabel("Add segmentation algorithm:"), "wrap");
        this.addButtons(segmenterListModel, list);
        this.add(list);
    }

    private void addButtons(SegmenterListModel segmenterListModel, JPanel list) {
        Context context = segmenterListModel.context();
        SegmentationPluginService pluginService = (SegmentationPluginService)context.service(SegmentationPluginService.class);
        for (SegmentationPlugin sp : pluginService.getSegmentationPlugins()) {
            JButton button = new JButton(sp.getTitle());
            button.addActionListener(ignore -> segmenterListModel.addSegmenter(sp));
            list.add((Component)button, "grow, wrap");
        }
    }

    public static void main(String ... args) {
        JFrame frame = new JFrame("Select Segmentation Algorithm");
        Context context = SingletonContext.getInstance();
        SegmenterListModel slm = new SegmenterListModel(context);
        frame.add(new AddSegmenterPanel(slm));
        frame.setSize(300, 300);
        frame.setVisible(true);
    }
}

