/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.imglib2.Dimensions;
import net.imglib2.labkit.BasicLabelingComponent;
import net.imglib2.labkit.models.ImageLabelingModel;
import net.imglib2.labkit.panel.GuiUtils;
import net.imglib2.util.Intervals;
import net.miginfocom.swing.MigLayout;

public class ImageInfoPanel {
    private ImageInfoPanel() {
    }

    public static JPanel newFramedImageInfoPanel(ImageLabelingModel imageLabelingModel, BasicLabelingComponent labelingComponent) {
        return GuiUtils.createCheckboxGroupedPanel(imageLabelingModel.imageVisibility(), "Image", ImageInfoPanel.createDimensionsInfo((Dimensions)imageLabelingModel.labeling().get(), labelingComponent));
    }

    private static JComponent createDimensionsInfo(Dimensions interval, BasicLabelingComponent labelingComponent) {
        Color background = UIManager.getColor("List.background");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 8, gap 8", "10[grow]", ""));
        panel.setBackground(background);
        JLabel label = new JLabel("Dimensions: " + Arrays.toString(Intervals.dimensionsAsLongArray((Dimensions)interval)));
        panel.add((Component)label, "grow, span, wrap");
        if (labelingComponent != null) {
            JButton button = new JButton("auto contrast");
            button.addActionListener(ignore -> labelingComponent.autoContrast());
            panel.add((Component)button, "grow, span");
        }
        return panel;
    }
}

