/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import net.imglib2.labkit.DefaultExtensible;
import net.imglib2.labkit.labeling.Label;
import net.imglib2.labkit.models.ColoredLabelsModel;
import net.imglib2.labkit.models.LabelingModel;
import net.imglib2.labkit.panel.ComponentList;
import net.imglib2.labkit.panel.GuiUtils;
import net.imglib2.type.numeric.ARGBType;
import net.miginfocom.swing.MigLayout;
import org.scijava.ui.behaviour.util.RunnableAction;

public class LabelPanel {
    private final ColoredLabelsModel model;
    private final ComponentList<Label, JPanel> list = new ComponentList();
    private final JPanel panel;
    private final JFrame dialogParent;
    private final Function<Supplier<Label>, JPopupMenu> menuFactory;

    public LabelPanel(JFrame dialogParent, ColoredLabelsModel model, boolean fixedLabels, Function<Supplier<Label>, JPopupMenu> menuFactory) {
        this.model = model;
        this.dialogParent = dialogParent;
        this.panel = this.initPanel(fixedLabels);
        this.menuFactory = menuFactory;
        model.listeners().addListener(this::update);
        model.selected().notifier().addListener(() -> this.list.setSelected(model.selected().get()));
        this.list.listeners().addListener(() -> model.selected().set(this.list.getSelected()));
        this.update();
    }

    public static JPanel newFramedLabelPanel(LabelingModel imageLabelingModel, DefaultExtensible extensible, boolean fixedLabels) {
        return GuiUtils.createCheckboxGroupedPanel(imageLabelingModel.labelingVisibility(), "Labeling", new LabelPanel(extensible.dialogParent(), new ColoredLabelsModel(imageLabelingModel), fixedLabels, item1 -> extensible.createPopupMenu(Label.LABEL_MENU, item1)).getComponent());
    }

    public JComponent getComponent() {
        return this.panel;
    }

    private void update() {
        this.list.clear();
        List<Label> items = this.model.items();
        items.forEach(label -> this.list.add((Label)label, new EntryPanel((Label)label)));
    }

    private JPanel initPanel(boolean fixedLabels) {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0, gap 0", "[grow]", "[grow][]"));
        this.list.listeners().addListener(this::changeSelectedLabel);
        this.list.getComponent().setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)this.list.getComponent(), "grow, span, push, wrap");
        if (!fixedLabels) {
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setBackground(UIManager.getColor("List.background"));
            buttonsPanel.setLayout((LayoutManager)new MigLayout("insets 4pt, gap 4pt", "[grow]", ""));
            buttonsPanel.add((Component)GuiUtils.createActionIconButton("Add label", (Action)new RunnableAction("Add label", this::addLabel), "add.png"), "");
            buttonsPanel.add((Component)GuiUtils.createActionIconButton("Remove all", (Action)new RunnableAction("Remove all", this::removeAllLabels), "remove.png"), "gapbefore push");
            panel.add((Component)buttonsPanel, "grow, span");
        }
        return panel;
    }

    private void changeSelectedLabel() {
        Label label = this.list.getSelected();
        if (label != null) {
            this.model.selected().set(label);
        }
    }

    private void addLabel() {
        this.model.addLabel();
    }

    private void removeAllLabels() {
        ArrayList<Label> items = new ArrayList<Label>(this.model.items());
        items.forEach(this.model::removeLabel);
    }

    private void renameLabel(Label label) {
        String oldName = label.name();
        String newName = JOptionPane.showInputDialog(this.dialogParent, "Rename label \"" + oldName + "\" to:", oldName);
        if (newName == null) {
            return;
        }
        this.model.renameLabel(label, newName);
    }

    private void changeColor(Label label) {
        ARGBType color = label.color();
        Color newColor = JColorChooser.showDialog(this.dialogParent, "Choose Color for Label \"" + label.name() + "\"", new Color(color.get()));
        if (newColor == null) {
            return;
        }
        this.model.setColor(label, new ARGBType(newColor.getRGB()));
    }

    private void localize(Label label) {
        this.model.localizeLabel(label);
    }

    private class EntryPanel
    extends JPanel {
        private final Label label;

        EntryPanel(Label label) {
            this.label = label;
            this.setOpaque(true);
            this.setLayout((LayoutManager)new MigLayout("insets 4pt, gap 4pt, fillx"));
            this.add(this.initColorButton());
            this.add((Component)new JLabel(label.name()), "grow, push, width 0:0:pref");
            JPopupMenu menu = (JPopupMenu)LabelPanel.this.menuFactory.apply(() -> this.label);
            this.add(this.initPopupMenuButton(menu));
            this.setComponentPopupMenu(menu);
            this.add((Component)this.initFinderButton(), "gapx 4pt");
            this.add(this.initVisibilityCheckbox());
            this.initRenameOnDoubleClick();
        }

        private JCheckBox initVisibilityCheckbox() {
            JCheckBox checkBox = GuiUtils.styleCheckboxUsingEye(new JCheckBox());
            checkBox.setSelected(this.label.isVisible());
            checkBox.addItemListener(event -> LabelPanel.this.model.setActive(this.label, event.getStateChange() == 1));
            checkBox.setOpaque(false);
            return checkBox;
        }

        private JButton initPopupMenuButton(JPopupMenu menu) {
            BasicArrowButton button = new BasicArrowButton(5);
            button.addActionListener(actionEvent -> menu.show(button, 0, button.getHeight()));
            return button;
        }

        private void initRenameOnDoubleClick() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        LabelPanel.this.renameLabel(EntryPanel.this.label);
                    }
                }
            });
        }

        private JButton initColorButton() {
            JButton colorButton = new JButton();
            colorButton.setBorder(new EmptyBorder(1, 1, 1, 1));
            colorButton.setIcon(GuiUtils.createIcon(new Color(this.label.color().get())));
            colorButton.addActionListener(l -> LabelPanel.this.changeColor(this.label));
            return colorButton;
        }

        private JButton initFinderButton() {
            return GuiUtils.createIconButton((Action)GuiUtils.createAction("locate", () -> LabelPanel.this.localize(this.label), "crosshair.png"));
        }
    }
}

