/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.panel;

import bdv.util.BdvHandle;
import bdv.viewer.ViewerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import net.imglib2.labkit.brush.FloodFillController;
import net.imglib2.labkit.brush.LabelBrushController;
import net.imglib2.labkit.brush.SelectLabelController;
import net.imglib2.labkit.panel.GuiUtils;
import net.miginfocom.swing.MigLayout;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.BehaviourMap;
import org.scijava.ui.behaviour.InputTrigger;
import org.scijava.ui.behaviour.InputTriggerMap;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class LabelToolsPanel
extends JPanel {
    private static final String BUTTON_BEHAVIOUR_ID = "panel";
    private static final Color OPTIONS_BORDER = new Color(220, 220, 220);
    private static final Color OPTIONS_BACKGROUND = new Color(230, 230, 230);
    private static final EnumSet<Mode> BRUSH_MODES = EnumSet.of(Mode.PAINT, Mode.ERASE);
    private final TriggerBehaviourBindings triggerBindings;
    private final FloodFillController floodFillController;
    private final LabelBrushController brushController;
    private final SelectLabelController selectLabelController;
    private JPanel brushOptionsPanel;
    private final MouseAdapter brushMotionDrawer;
    private final ViewerPanel bdvPanel;
    private final ButtonGroup group = new ButtonGroup();

    public LabelToolsPanel(BdvHandle bdvHandle, LabelBrushController brushController, FloodFillController floodFillController, SelectLabelController selectLabelController) {
        this.brushController = brushController;
        this.floodFillController = floodFillController;
        this.selectLabelController = selectLabelController;
        this.triggerBindings = bdvHandle.getTriggerbindings();
        this.bdvPanel = bdvHandle.getViewerPanel();
        this.setLayout((LayoutManager)new MigLayout("flowy, insets 0, gap 4pt, top", "[][][][][]", "[]push"));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        this.initActionButtons();
        this.add((Component)this.initOptionPanel(), "wrap, growy");
        this.brushMotionDrawer = GuiUtils.toMouseListener(brushController.drawBrushBehaviour());
        this.setMode(Mode.MOVE);
    }

    private void setMode(Mode mode) {
        this.setVisibility(mode);
        this.setBindings(mode);
    }

    private void setBindings(Mode mode) {
        this.removeBindings();
        if (mode == Mode.MOVE) {
            return;
        }
        this.addBindings(this.getBehaviourId(mode));
    }

    private Behaviour getBehaviourId(Mode mode) {
        switch (mode) {
            case MOVE: {
                throw new AssertionError();
            }
            case PAINT: {
                return this.brushController.paintBehaviour();
            }
            case FLOOD_FILL: {
                return this.floodFillController.floodFillBehaviour();
            }
            case ERASE: {
                return this.brushController.eraseBehaviour();
            }
            case FLOOD_ERASE: {
                return this.floodFillController.floodEraseBehaviour();
            }
            case SELECT_LABEL: {
                return this.selectLabelController.behaviour();
            }
        }
        throw new AssertionError();
    }

    private void setVisibility(Mode mode) {
        boolean brushVisible = BRUSH_MODES.contains((Object)mode);
        if (this.brushOptionsPanel != null) {
            this.brushOptionsPanel.setVisible(brushVisible);
        }
        if (brushVisible) {
            this.showLabelCursor();
        } else {
            this.hideLabelCursor();
        }
    }

    private void initActionButtons() {
        JToggleButton moveBtn = this.addActionButton("Move", Mode.MOVE, "/images/move.png");
        this.addActionButton("Draw (D)", Mode.PAINT, "/images/draw.png");
        this.addActionButton("Flood Fill (F)\nThis only works properly on 2D images", Mode.FLOOD_FILL, "/images/fill.png");
        this.addActionButton("Erase (E)", Mode.ERASE, "/images/erase.png");
        this.addActionButton("Remove Blob (R)", Mode.FLOOD_ERASE, "/images/flooderase.png");
        this.addActionButton("Select Label (Shift)", Mode.SELECT_LABEL, "/images/pipette.png");
        moveBtn.doClick();
    }

    private JPanel initOptionPanel() {
        JPanel optionPane = new JPanel();
        optionPane.setLayout((LayoutManager)new MigLayout("insets 0"));
        optionPane.add(this.initOverrideCheckBox());
        optionPane.add((Component)this.initBrushOptionPanel(), "al left");
        optionPane.setBackground(OPTIONS_BACKGROUND);
        optionPane.setBorder(BorderFactory.createLineBorder(OPTIONS_BORDER));
        return optionPane;
    }

    private JToggleButton addActionButton(String toolTipText, Mode mode, String iconPath) {
        JToggleButton button = new JToggleButton();
        button.setIcon(new ImageIcon(this.getClass().getResource(iconPath)));
        button.setToolTipText(toolTipText);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addItemListener(ev -> {
            if (ev.getStateChange() == 1) {
                this.setMode(mode);
            }
        });
        this.group.add(button);
        this.add((Component)button, "wrap, top");
        return button;
    }

    private JPanel initBrushOptionPanel() {
        this.brushOptionsPanel = new JPanel();
        this.brushOptionsPanel.setLayout((LayoutManager)new MigLayout("insets 4pt, gap 2pt, wmax 300"));
        this.brushOptionsPanel.setOpaque(false);
        this.brushOptionsPanel.add((Component)new JLabel("Brush size:"), "grow");
        JSlider brushSizeSlider = this.initBrushSizeSlider();
        this.brushOptionsPanel.add((Component)brushSizeSlider, "grow");
        this.brushOptionsPanel.add((Component)this.initSliderValueLabel(brushSizeSlider), "right");
        return this.brushOptionsPanel;
    }

    private JCheckBox initOverrideCheckBox() {
        JCheckBox checkBox = new JCheckBox("allow overlapping labels");
        checkBox.setOpaque(false);
        checkBox.addItemListener(action -> {
            boolean overlapping = action.getStateChange() == 1;
            this.brushController.setOverlapping(overlapping);
            this.floodFillController.setOverlapping(overlapping);
        });
        return checkBox;
    }

    private JSlider initBrushSizeSlider() {
        JSlider brushSize = new JSlider(1, 50, (int)this.brushController.getBrushRadius());
        brushSize.setPaintTrack(true);
        brushSize.addChangeListener(e -> this.brushController.setBrushRadius(brushSize.getValue()));
        brushSize.setOpaque(false);
        return brushSize;
    }

    private JLabel initSliderValueLabel(JSlider brushSize) {
        JLabel valLabel = new JLabel(String.valueOf(brushSize.getValue()));
        brushSize.addChangeListener(e -> valLabel.setText(String.valueOf(brushSize.getValue())));
        return valLabel;
    }

    private void showLabelCursor() {
        this.bdvPanel.getDisplay().addMouseListener((MouseListener)this.brushMotionDrawer);
        this.bdvPanel.getDisplay().addMouseMotionListener((MouseMotionListener)this.brushMotionDrawer);
    }

    private void hideLabelCursor() {
        this.bdvPanel.getDisplay().removeMouseListener((MouseListener)this.brushMotionDrawer);
        this.bdvPanel.getDisplay().removeMouseMotionListener((MouseMotionListener)this.brushMotionDrawer);
    }

    private void addBindings(Behaviour behaviour) {
        BehaviourMap behaviourMap = new BehaviourMap();
        behaviourMap.put("label tool button1", behaviour);
        behaviourMap.put("drag rotate", new Behaviour(){});
        behaviourMap.put("2d drag rotate", new Behaviour(){});
        InputTriggerMap inputTriggerMap = new InputTriggerMap();
        inputTriggerMap.put(InputTrigger.getFromString((String)"button1"), "label tool button1");
        this.triggerBindings.addInputTriggerMap(BUTTON_BEHAVIOUR_ID, inputTriggerMap, new String[0]);
        this.triggerBindings.addBehaviourMap(BUTTON_BEHAVIOUR_ID, behaviourMap);
    }

    private void removeBindings() {
        this.triggerBindings.removeInputTriggerMap(BUTTON_BEHAVIOUR_ID);
        this.triggerBindings.removeBehaviourMap(BUTTON_BEHAVIOUR_ID);
    }

    private static enum Mode {
        MOVE,
        PAINT,
        FLOOD_FILL,
        ERASE,
        SELECT_LABEL,
        FLOOD_ERASE;

    }
}

