/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;
import net.imglib2.labkit.DefaultExtensible;
import net.imglib2.labkit.models.SegmentationItem;
import net.imglib2.labkit.models.SegmenterListModel;
import net.imglib2.labkit.panel.AddSegmenterPanel;
import net.imglib2.labkit.panel.ComponentList;
import net.imglib2.labkit.panel.GuiUtils;
import net.imglib2.labkit.segmentation.SegmentationPlugin;
import net.imglib2.labkit.segmentation.SegmentationPluginService;
import net.imglib2.labkit.segmentation.TrainClassifier;
import net.imglib2.labkit.utils.ParallelUtils;
import net.miginfocom.swing.MigLayout;
import org.scijava.ui.behaviour.util.RunnableAction;

public class SegmenterPanel
extends JPanel {
    private final SegmenterListModel segmentationModel;
    private final ComponentList<SegmentationItem, JPanel> list = new ComponentList();
    private final Function<Supplier<SegmentationItem>, JPopupMenu> menuFactory;
    private final JPanel listPanel = new JPanel();
    private final AddSegmenterPanel addSegmenterPanel;
    private JButton addSegmenterButton;
    private final Runnable updateList = this::updateList;

    public SegmenterPanel(SegmenterListModel segmentationModel, Function<Supplier<SegmentationItem>, JPopupMenu> menuFactory) {
        this.segmentationModel = segmentationModel;
        this.menuFactory = menuFactory;
        this.addSegmenterPanel = new AddSegmenterPanel(segmentationModel);
        this.setLayout(new BorderLayout());
        this.add(this.addSegmenterPanel);
        this.listPanel.setLayout((LayoutManager)new MigLayout("insets 0, gap 0", "[grow]", "[grow][]"));
        this.listPanel.add((Component)this.initList(), "grow, wrap");
        this.listPanel.add((Component)this.initBottomPanel(), "grow");
    }

    public static JPanel newFramedSegmeterPanel(SegmenterListModel segmentationModel, DefaultExtensible extensible) {
        SegmenterPanel segmenterPanel = new SegmenterPanel(segmentationModel, item -> extensible.createPopupMenu(SegmentationItem.SEGMENTER_MENU, item));
        return GuiUtils.createCheckboxGroupedPanel(segmentationModel.segmentationVisibility(), "Segmentation", segmenterPanel);
    }

    private JComponent initBottomPanel() {
        JPanel result = new JPanel();
        result.setBackground(UIManager.getColor("List.background"));
        result.setLayout((LayoutManager)new MigLayout("insets 4pt, gap 4pt"));
        result.add(this.initAddButton());
        return result;
    }

    private JButton initAddButton() {
        this.addSegmenterButton = GuiUtils.createActionIconButton("Add classifier", (Action)new RunnableAction("Add classifier", this::showAddSegmenterPopupMenu), "add.png");
        return this.addSegmenterButton;
    }

    private void showAddSegmenterPopupMenu() {
        SegmentationPluginService pluginService = (SegmentationPluginService)this.segmentationModel.context().service(SegmentationPluginService.class);
        List<SegmentationPlugin> plugins = pluginService.getSegmentationPlugins();
        JPopupMenu menu = new JPopupMenu();
        for (SegmentationPlugin plugin : plugins) {
            JMenuItem menuItem = new JMenuItem(plugin.getTitle());
            menuItem.addActionListener(ignore -> this.addSegmenter(plugin));
            menu.add(menuItem);
        }
        menu.show(this.addSegmenterButton, 0, this.addSegmenterButton.getHeight());
    }

    private void addSegmenter(SegmentationPlugin plugin) {
        this.segmentationModel.addSegmenter(plugin);
    }

    private void updateList() {
        List<SegmentationItem> segmenters = this.segmentationModel.segmenters().get();
        this.updateVisiblePanel(segmenters.isEmpty());
        this.list.clear();
        segmenters.forEach(item -> this.list.add((SegmentationItem)item, new EntryPanel((SegmentationItem)item)));
        this.list.setSelected(this.segmentationModel.selectedSegmenter().get());
        this.revalidate();
        this.repaint();
    }

    private void updateVisiblePanel(boolean empty) {
        if (empty != (this.getComponent(0) == this.addSegmenterPanel)) {
            this.removeAll();
            this.add(empty ? this.addSegmenterPanel : this.listPanel);
        }
    }

    private JComponent initList() {
        this.updateList();
        this.list.listeners().addListener(this::userChangedSelection);
        this.segmentationModel.segmenters().notifier().addWeakListener(this.updateList);
        JComponent component = this.list.getComponent();
        component.setBorder(BorderFactory.createEmptyBorder());
        return component;
    }

    private void userChangedSelection() {
        SegmentationItem selectedValue = this.list.getSelected();
        if (selectedValue != null) {
            this.segmentationModel.selectedSegmenter().set(selectedValue);
        }
    }

    private class EntryPanel
    extends JPanel {
        private final SegmentationItem item;
        private final RunnableAction settingsAction = GuiUtils.createAction("Settings ...", this::showSettings, "gear.png");
        private final RunnableAction trainAction = GuiUtils.createAction("Train", this::runTraining, "run.png");

        private EntryPanel(SegmentationItem item) {
            this.item = item;
            this.setLayout((LayoutManager)new MigLayout("inset 4, gap 4, fillx"));
            JLabel label = new JLabel(item.toString());
            this.add((Component)label, "push, grow, width 0:0:1000");
            this.add(this.initPopupMenuButton());
            this.add(GuiUtils.createIconButton((Action)this.settingsAction));
            this.add(GuiUtils.createIconButton((Action)this.trainAction));
        }

        private JButton initPopupMenuButton() {
            JPopupMenu menu = this.initPopupMenu();
            BasicArrowButton button = new BasicArrowButton(5);
            button.addActionListener(actionEvent -> menu.show(button, 0, button.getHeight()));
            return button;
        }

        private JPopupMenu initPopupMenu() {
            return (JPopupMenu)SegmenterPanel.this.menuFactory.apply(() -> this.item);
        }

        private void showSettings() {
            this.item.editSettings(null, SegmenterPanel.this.segmentationModel.trainingData().get());
        }

        private void runTraining() {
            ParallelUtils.runInOtherThread(() -> {
                SegmenterPanel.this.segmentationModel.selectedSegmenter().set(this.item);
                TrainClassifier.trainSelectedSegmenter(SegmenterPanel.this.segmentationModel);
            });
        }
    }
}

