/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.plugin;

import bdv.util.AbstractSource;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;

public class ResolutionPyramidSource<T extends NumericType<T>>
extends AbstractSource<T> {
    private final List<? extends RandomAccessibleInterval<T>> resolutionPyramid;

    public ResolutionPyramidSource(List<? extends RandomAccessibleInterval<T>> resolutionPyramid, T type, String name) {
        super(type, name);
        assert (resolutionPyramid.stream().allMatch(source -> source.numDimensions() == 2));
        this.resolutionPyramid = resolutionPyramid;
    }

    public RandomAccessibleInterval<T> getSource(int t, int level) {
        return Views.addDimension(this.resolutionPyramid.get(level), (long)0L, (long)0L);
    }

    public int getNumMipmapLevels() {
        return this.resolutionPyramid.size();
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        ResolutionPyramidSource.getTransform(transform, this.getScale(level));
    }

    private double getScale(int level) {
        long downscaledSizeX;
        long integerScale;
        long fullSizeX = this.resolutionPyramid.get(0).dimension(0);
        if (fullSizeX / (integerScale = fullSizeX / (downscaledSizeX = this.resolutionPyramid.get(level).dimension(0))) == downscaledSizeX) {
            return integerScale;
        }
        return (double)fullSizeX / (double)downscaledSizeX;
    }

    private static void getTransform(AffineTransform3D transform, double scale) {
        double translation = scale * 0.5 - 0.5;
        transform.set(scale, 0.0, 0.0, translation, 0.0, scale, 0.0, translation, 0.0, 0.0, scale, 0.0);
    }
}

