/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.plugin;

import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterConsole;
import java.io.File;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.labkit.inputimage.DatasetInputImage;
import net.imglib2.labkit.segmentation.SegmentationUtils;
import net.imglib2.labkit.segmentation.weka.TrainableSegmentationSegmenter;
import net.imglib2.labkit.utils.ParallelUtils;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.util.Intervals;
import org.scijava.Cancelable;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins > Segmentation > Labkit > Macro Recordable > Segment Image with Labkit")
public class SegmentImageWithLabkitPlugin
implements Command,
Cancelable {
    @Parameter
    private Context context;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private Dataset input;
    @Parameter
    private File segmenter_file;
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset output;
    @Parameter(required=false)
    private Boolean use_gpu = false;

    public void run() {
        TrainableSegmentationSegmenter segmenter = new TrainableSegmentationSegmenter(this.context);
        segmenter.setUseGpu(this.use_gpu);
        segmenter.openModel(this.segmenter_file.getAbsolutePath());
        ImgPlus<? extends NumericType<?>> imgPlus = new DatasetInputImage(this.input).imageForSegmentation();
        Img<ShortType> outputImg = this.useCache(imgPlus) ? this.calculateOnCachedImg(segmenter, imgPlus) : this.calculateOnArrayImg(segmenter, imgPlus);
        this.output = this.datasetService.create(outputImg);
    }

    private boolean useCache(ImgPlus<?> imgPlus) {
        return Intervals.numElements(imgPlus) > 100000000L;
    }

    private Img<ShortType> calculateOnCachedImg(TrainableSegmentationSegmenter segmenter, ImgPlus<?> imgPlus) {
        Img<ShortType> outputImg = SegmentationUtils.createCachedSegmentation(segmenter, imgPlus);
        ParallelUtils.populateCachedImg(outputImg, (ProgressWriter)new ProgressWriterConsole());
        return outputImg;
    }

    private Img<ShortType> calculateOnArrayImg(TrainableSegmentationSegmenter segmenter, ImgPlus<?> imgPlus) {
        Interval outputInterval = SegmentationUtils.intervalNoChannels(imgPlus);
        int[] cellSize = segmenter.suggestCellSize(imgPlus);
        ArrayImg outputImg = ArrayImgs.shorts((long[])Intervals.dimensionsAsLongArray((Dimensions)outputInterval));
        ParallelUtils.applyOperationOnCells(outputImg, cellSize, outputCell -> segmenter.segment(imgPlus, (RandomAccessibleInterval<? extends IntegerType<?>>)outputCell), (ProgressWriter)new ProgressWriterConsole());
        return outputImg;
    }

    public boolean isCanceled() {
        return false;
    }

    public void cancel(String reason) {
    }

    public String getCancelReason() {
        return null;
    }
}

