/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.plugin.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.gui.BufferedImageReader;
import net.miginfocom.swing.MigLayout;

public class ImageSelectionDialog {
    private final String filename;
    private final BufferedImageReader thumbReader;
    private final List<List<Integer>> sectionIndices;
    private final List<JRadioButton> boxes;
    private final JComponent component;
    private int selectedSection = 0;

    public static ImageSelectionDialog show(ImageReader reader) {
        ImageSelectionDialog dialog = new ImageSelectionDialog(reader);
        int result = JOptionPane.showConfirmDialog(null, dialog.component(), "Select a section", 2);
        if (result != 0) {
            throw new CancellationException();
        }
        dialog.updateSelectedSection();
        return dialog;
    }

    private ImageSelectionDialog(ImageReader reader) {
        this.filename = reader.getCurrentFile();
        this.thumbReader = new BufferedImageReader((IFormatReader)reader);
        this.sectionIndices = this.computeSectionIndices();
        this.boxes = this.initBoxes();
        this.component = new JScrollPane(this.createSections());
    }

    public List<Integer> getSelectedSectionIndices() {
        return this.sectionIndices.get(this.selectedSection);
    }

    public String getLabelingFilename() {
        return this.labelingFilename(this.selectedSection);
    }

    private JComponent component() {
        return this.component;
    }

    private void updateSelectedSection() {
        for (int i = 0; i < this.boxes.size(); ++i) {
            if (!this.boxes.get(i).isSelected()) continue;
            this.selectedSection = i;
        }
    }

    private List<List<Integer>> computeSectionIndices() {
        ArrayList<List<Integer>> sections = new ArrayList<List<Integer>>();
        ArrayList<Integer> indices = null;
        int lastWidth = -1;
        int lastHeight = -1;
        for (int i = 0; i < this.thumbReader.getSeriesCount(); ++i) {
            this.thumbReader.setSeries(i);
            if (this.thumbReader.isThumbnailSeries()) continue;
            int width = this.thumbReader.getSizeX();
            int height = this.thumbReader.getSizeY();
            if (indices == null || Math.abs(width - lastWidth / 2) > 2 || Math.abs(height - lastHeight / 2) > 2) {
                indices = new ArrayList<Integer>();
                sections.add(indices);
            }
            indices.add(i);
            lastWidth = width;
            lastHeight = height;
        }
        return sections;
    }

    private List<JRadioButton> initBoxes() {
        ButtonGroup buttonGroup = new ButtonGroup();
        ArrayList<JRadioButton> boxes = new ArrayList<JRadioButton>();
        for (int i = 0; i < this.sectionIndices.size(); ++i) {
            JRadioButton button = new JRadioButton(String.valueOf(i + 1));
            buttonGroup.add(button);
            boxes.add(button);
        }
        return boxes;
    }

    private Panel createSections() {
        Panel panel = new Panel();
        panel.setLayout((LayoutManager)new MigLayout("", "[]20[][]", ""));
        panel.add((Component)new JLabel("Please select a section. You can choose the resolution in the next step."), "grow, span,wrap");
        for (int i = 0; i < this.sectionIndices.size(); ++i) {
            panel.add(this.line(), "grow, span, wrap");
            panel.add(this.boxes.get(i));
            panel.add(this.descriptiveLabel(i), "grow,push");
            panel.add(this.thumbPanel(i), "wrap");
        }
        return panel;
    }

    private Component line() {
        JPanel line = new JPanel();
        line.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.lightGray));
        return line;
    }

    private Component descriptiveLabel(int i) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        label.setFont(font.deriveFont(font.getStyle() & 0xFFFFFFFE));
        String labelText = "<html>";
        if (this.labelingExists(i)) {
            labelText = labelText + "<b>[existing labeling found]</b><br />";
        }
        labelText = labelText + "<font face=\"verdana\">";
        for (int j : this.sectionIndices.get(i)) {
            this.thumbReader.setSeries(j);
            labelText = labelText + this.thumbReader.getSizeX() + " x " + this.thumbReader.getSizeY() + "<br/>";
        }
        label.setText(labelText);
        return label;
    }

    private Component thumbPanel(int index) {
        try {
            int series = this.sectionIndices.get(index).stream().max(Integer::compareTo).orElse(0);
            this.thumbReader.setSeries(series);
            BufferedImage image = this.thumbReader.openThumbImage(this.thumbReader.getIndex(this.thumbReader.getSizeZ() / 2, 0, this.thumbReader.getSizeT() / 2));
            Panel thumbPanel = new Panel();
            thumbPanel.add(new JLabel(new ImageIcon(image)));
            return thumbPanel;
        }
        catch (IOException | FormatException e) {
            return new JPanel();
        }
    }

    private boolean labelingExists(int i) {
        return new File(this.labelingFilename(i)).exists();
    }

    private String labelingFilename(Integer index) {
        if (this.filename.endsWith(".czi") && index != null) {
            return this.filename.substring(0, this.filename.length() - ".czi".length()) + "-" + (index + 1) + ".czi.labeling";
        }
        return this.filename + ".labeling";
    }
}

