/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.project;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.imglib2.labkit.actions.AbstractFileIoAction;
import net.imglib2.labkit.project.LabeledImage;
import net.imglib2.labkit.project.LabkitProjectEditor;
import net.imglib2.labkit.project.LabkitProjectModel;
import net.miginfocom.swing.MigLayout;

public class LabeledImagesListPanel
extends JPanel {
    private final LabkitProjectModel model;
    private final JList<LabeledImage> list;
    private final MyListModel listModel = new MyListModel();

    public LabeledImagesListPanel(LabkitProjectModel model) {
        this.model = model;
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[grow]0px[]"));
        this.list = LabeledImagesListPanel.initList(model);
        this.list.setModel(this.listModel);
        model.changeNotifier().addListener(() -> this.listModel.triggerUpdate());
        this.add((Component)this.initScrollPane(this.list), "grow, wrap");
        JPanel buttonsPanel = this.initButtonsPanel();
        buttonsPanel.setBackground(this.list.getBackground());
        this.add((Component)buttonsPanel, "grow");
    }

    private JScrollPane initScrollPane(JList<LabeledImage> list) {
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    private JPanel initButtonsPanel() {
        JPanel buttonsPanel = new JPanel((LayoutManager)new MigLayout());
        JButton addImageButton = new JButton("Add image");
        addImageButton.addActionListener(ignore -> this.onAddImageClicked(addImageButton));
        buttonsPanel.add(addImageButton);
        JButton editProjectButton = new JButton("Edit project");
        editProjectButton.addActionListener(ignore -> this.onEditProjectButtonClicked());
        buttonsPanel.add(editProjectButton);
        return buttonsPanel;
    }

    private void onAddImageClicked(JButton button) {
        JFileChooser chooser = new JFileChooser("Select Image");
        chooser.setFileFilter(AbstractFileIoAction.TIFF_FILTER);
        chooser.setMultiSelectionEnabled(true);
        int result = chooser.showOpenDialog(button);
        if (result == 0) {
            File[] files;
            for (File file : files = chooser.getSelectedFiles()) {
                String filename = file.getPath();
                LabeledImage newLabeledImage = new LabeledImage(this.model.context(), filename);
                this.model.labeledImages().add(newLabeledImage);
                this.model.changeNotifier().notifyListeners();
            }
        }
    }

    private void onEditProjectButtonClicked() {
        LabkitProjectEditor.show(this.model);
    }

    private static JList<LabeledImage> initList(LabkitProjectModel labkitProjectModel) {
        JList<LabeledImage> list = new JList<LabeledImage>(labkitProjectModel.labeledImages().toArray(new LabeledImage[0]));
        list.setCellRenderer(new MyListItemRenderer());
        list.addListSelectionListener(event -> {
            if (!event.getValueIsAdjusting()) {
                labkitProjectModel.selectedImage().set((LabeledImage)list.getSelectedValue());
            }
        });
        return list;
    }

    private static class MyListItemRenderer
    extends DefaultListCellRenderer {
        private MyListItemRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof LabeledImage && ((LabeledImage)value).modified().get().booleanValue()) {
                this.setForeground(Color.blue);
            }
            return this;
        }
    }

    private class MyListModel
    implements ListModel<LabeledImage> {
        private final List<ListDataListener> listeners = new CopyOnWriteArrayList<ListDataListener>();
        private final Set<LabeledImage> observedElements = new HashSet<LabeledImage>();
        private final Runnable updateListener = this::triggerUpdate;

        private MyListModel() {
        }

        private void triggerUpdate() {
            this.unregisterAll();
            ListDataEvent e = new ListDataEvent(this, 0, 0, LabeledImagesListPanel.this.model.labeledImages().size());
            this.listeners.forEach(l -> l.contentsChanged(e));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterAll() {
            Set<LabeledImage> set = this.observedElements;
            synchronized (set) {
                for (LabeledImage labeledImage : this.observedElements) {
                    labeledImage.modified().notifier().removeListener(this.updateListener);
                }
            }
            this.observedElements.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void register(LabeledImage labeledImage) {
            Set<LabeledImage> set = this.observedElements;
            synchronized (set) {
                if (this.observedElements.add(labeledImage)) {
                    labeledImage.modified().notifier().addListener(this.updateListener);
                }
            }
        }

        @Override
        public int getSize() {
            return LabeledImagesListPanel.this.model.labeledImages().size();
        }

        @Override
        public LabeledImage getElementAt(int index) {
            LabeledImage labeledImage = LabeledImagesListPanel.this.model.labeledImages().get(index);
            this.register(labeledImage);
            return labeledImage;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }
    }
}

