/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.project;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.UnaryOperator;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.imglib2.labkit.actions.AbstractFileIoAction;
import net.imglib2.labkit.project.LabeledImage;
import net.imglib2.labkit.project.LabkitProjectModel;
import net.imglib2.labkit.utils.FileChooserCellEditor;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;

public class LabkitProjectEditor
extends JPanel {
    private final LabkitProjectModel model;
    private final MyTableModel tableModel = new MyTableModel();
    private final JTable table;

    public LabkitProjectEditor(LabkitProjectModel model) {
        this.model = model;
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][grow][]"));
        this.add((Component)new JLabel("Double click on the table to make changes."), "wrap");
        this.table = new JTable(this.tableModel);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(1).setCellEditor(new FileChooserCellEditor());
        columnModel.getColumn(2).setCellEditor(new FileChooserCellEditor());
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(1).setPreferredWidth(100);
        columnModel.getColumn(2).setPreferredWidth(100);
        this.add((Component)new JScrollPane(this.table), "grow, wrap");
        this.add(this.newButton("Add Images", this::onAddImagesClicked), "split");
        this.add(this.newButton("Remove Selected", this::onRemoveSelectedClicked));
        model.changeNotifier().addListener(() -> this.tableModel.updateView());
    }

    private void onAddImagesClicked() {
        JFileChooser chooser = new JFileChooser("Select Image");
        chooser.setFileFilter(AbstractFileIoAction.TIFF_FILTER);
        chooser.setMultiSelectionEnabled(true);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            File[] files;
            for (File file : files = chooser.getSelectedFiles()) {
                String filename = file.getPath();
                LabeledImage newLabeledImage = new LabeledImage(this.model.context(), filename);
                this.model.labeledImages().add(newLabeledImage);
                this.model.changeNotifier().notifyListeners();
            }
        }
    }

    private void onRemoveSelectedClicked() {
        this.removeItems(this.model.labeledImages(), this.table.getSelectedRows());
        this.model.changeNotifier().notifyListeners();
    }

    private void removeItems(List<LabeledImage> list, int[] indices) {
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            list.remove(indices[i]);
        }
    }

    private Component newButton(String label, Runnable action) {
        JButton button = new JButton(label);
        button.addActionListener(ignore -> action.run());
        return button;
    }

    public static void show(LabkitProjectModel model) {
        JFrame frame = new JFrame("Edit Labkit Project");
        frame.add(new LabkitProjectEditor(model));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    private class MyTableModel
    implements TableModel {
        private final List<String> COLUMN_TITLES = Arrays.asList("Nick Name", "Image File", "Labeling File");
        private final List<TableModelListener> tableListeners = new CopyOnWriteArrayList<TableModelListener>();

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return LabkitProjectEditor.this.model.labeledImages().size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_TITLES.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.COLUMN_TITLES.get(columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            LabeledImage labeledImage = LabkitProjectEditor.this.model.labeledImages().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return labeledImage.getName();
                }
                case 1: {
                    return labeledImage.getImageFile();
                }
                case 2: {
                    return labeledImage.getLabelingFile();
                }
            }
            throw new AssertionError();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    this.setName(rowIndex, (String)value);
                    return;
                }
                case 1: {
                    this.setImage(rowIndex, (String)value);
                    return;
                }
                case 2: {
                    this.setLabeling(rowIndex, (String)value);
                    return;
                }
            }
            throw new AssertionError();
        }

        private void setName(int rowIndex, String newName) {
            this.modifyLabeledImage(rowIndex, oldLabeledImage -> {
                oldLabeledImage.setName(newName);
                return oldLabeledImage;
            });
        }

        private void setImage(int rowIndex, String newImageFile) {
            this.modifyLabeledImage(rowIndex, oldLabeledImage -> {
                String name = oldLabeledImage.getName();
                if (name.equals(FilenameUtils.getName((String)oldLabeledImage.getImageFile()))) {
                    name = FilenameUtils.getName((String)newImageFile);
                }
                return new LabeledImage(LabkitProjectEditor.this.model.context(), name, newImageFile, oldLabeledImage.getLabelingFile());
            });
        }

        private void setLabeling(int rowIndex, String newLabelingFile) {
            this.modifyLabeledImage(rowIndex, oldLabeledImage -> new LabeledImage(LabkitProjectEditor.this.model.context(), oldLabeledImage.getName(), oldLabeledImage.getImageFile(), newLabelingFile));
        }

        private void modifyLabeledImage(int rowIndex, UnaryOperator<LabeledImage> operator) {
            LabeledImage oldLabeledImage = LabkitProjectEditor.this.model.labeledImages().get(rowIndex);
            LabeledImage newLabeledImage = (LabeledImage)operator.apply(oldLabeledImage);
            LabkitProjectEditor.this.model.labeledImages().set(rowIndex, newLabeledImage);
            LabkitProjectEditor.this.model.changeNotifier().notifyListeners();
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.tableListeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.tableListeners.remove(l);
        }

        private void updateView() {
            TableModelEvent e = new TableModelEvent(this);
            this.tableListeners.forEach(l -> l.tableChanged(e));
        }
    }
}

