/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.project;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.imglib2.labkit.project.LabeledImage;
import net.imglib2.labkit.project.LabkitProjectModel;
import org.scijava.Context;

public class LabkitProjectFileSerializer {
    private LabkitProjectFileSerializer() {
    }

    public static void save(LabkitProjectModel project, File file) throws IOException {
        ObjectMapper jackson = new ObjectMapper((JsonFactory)new YAMLFactory());
        PlainProjectData plain = LabkitProjectFileSerializer.asPlainProjectData(project);
        jackson.writeValue(file, (Object)plain);
    }

    public static LabkitProjectModel open(Context context, File file) throws IOException {
        ObjectMapper jackson = new ObjectMapper((JsonFactory)new YAMLFactory());
        PlainProjectData p = (PlainProjectData)jackson.readValue(file, PlainProjectData.class);
        return LabkitProjectFileSerializer.asLabkitProjectModel(context, p, file);
    }

    private static PlainProjectData asPlainProjectData(LabkitProjectModel project) {
        PlainProjectData p = new PlainProjectData();
        p.images = LabkitProjectFileSerializer.map(x -> LabkitProjectFileSerializer.asPlainLabeledImage(x), project.labeledImages());
        p.segmentation_algorithms = LabkitProjectFileSerializer.map(x -> LabkitProjectFileSerializer.asPlainSegmenter(x), project.segmenterFiles());
        return p;
    }

    private static PlainLabeledImage asPlainLabeledImage(LabeledImage labeledImage) {
        PlainLabeledImage e = new PlainLabeledImage();
        e.nick_name = labeledImage.getName();
        e.image_file = labeledImage.getImageFile();
        e.labeling_file = labeledImage.getLabelingFile();
        return e;
    }

    private static PlainSegmenter asPlainSegmenter(String file) {
        PlainSegmenter s = new PlainSegmenter();
        s.file = file;
        return s;
    }

    public static <T, R> List<R> map(Function<T, R> function, List<T> list) {
        ArrayList<R> result = new ArrayList<R>(list.size());
        for (T t : list) {
            result.add(function.apply(t));
        }
        return result;
    }

    private static LabkitProjectModel asLabkitProjectModel(Context context, PlainProjectData p, File projectFile) {
        List<LabeledImage> labeledImageFiles = LabkitProjectFileSerializer.map(x -> LabkitProjectFileSerializer.asLabeledImage(context, x), p.images);
        List<String> segmenterFiles = LabkitProjectFileSerializer.map(x -> x.file, p.segmentation_algorithms);
        LabkitProjectModel project = new LabkitProjectModel(context, projectFile.getParent(), labeledImageFiles);
        project.segmenterFiles().addAll(segmenterFiles);
        return project;
    }

    private static LabeledImage asLabeledImage(Context context, PlainLabeledImage image) {
        return new LabeledImage(context, image.nick_name, image.image_file, image.labeling_file);
    }

    private static class PlainSegmenter {
        public String file;

        private PlainSegmenter() {
        }
    }

    private static class PlainLabeledImage {
        public String nick_name;
        public String image_file;
        public String labeling_file;

        private PlainLabeledImage() {
        }
    }

    private static class PlainProjectData {
        public List<PlainLabeledImage> images;
        public List<PlainSegmenter> segmentation_algorithms;

        private PlainProjectData() {
        }
    }
}

