/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.project;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.labkit.models.DefaultHolder;
import net.imglib2.labkit.models.Holder;
import net.imglib2.labkit.project.LabeledImage;
import net.imglib2.labkit.utils.Notifier;
import org.scijava.Context;

public class LabkitProjectModel {
    private final Context context;
    private final String projectDirectory;
    private Holder<LabeledImage> selectedImage;
    private List<LabeledImage> labeledImageFiles;
    private List<String> segmenterFiles;
    private final Notifier changeNotifier = new Notifier();

    public LabkitProjectModel(Context context, String projectDirectory, List<LabeledImage> labeledImageFiles) {
        this.context = context;
        this.projectDirectory = projectDirectory;
        this.selectedImage = new DefaultHolder<Object>((labeledImageFiles.size() == 0 ? null : labeledImageFiles.get(0)));
        this.labeledImageFiles = labeledImageFiles;
        this.segmenterFiles = new ArrayList<String>();
        this.changeNotifier.addListener(this::onLabeledImagesChanged);
    }

    public String getProjectDirectory() {
        return this.projectDirectory;
    }

    public List<LabeledImage> labeledImages() {
        return this.labeledImageFiles;
    }

    public List<String> segmenterFiles() {
        return this.segmenterFiles;
    }

    public Context context() {
        return this.context;
    }

    public Notifier changeNotifier() {
        return this.changeNotifier;
    }

    public Holder<LabeledImage> selectedImage() {
        return this.selectedImage;
    }

    private void onLabeledImagesChanged() {
        if (this.labeledImageFiles.contains(this.selectedImage.get())) {
            return;
        }
        if (!this.labeledImageFiles.isEmpty()) {
            this.selectedImage.set(this.labeledImageFiles.get(0));
        } else {
            this.selectedImage.set(null);
        }
    }
}

