/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.project;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import net.imglib2.labkit.project.LabeledImage;
import net.imglib2.labkit.project.LabkitProjectEditor;
import net.imglib2.labkit.project.LabkitProjectFileSerializer;
import net.imglib2.labkit.project.LabkitProjectModel;
import net.miginfocom.swing.MigLayout;
import org.scijava.Context;

public class NewProjectDialog
extends JDialog {
    private final JTextField textField;
    private final LabkitProjectModel model;
    private boolean approved = false;

    private NewProjectDialog(Context context) {
        super((Frame)null);
        this.setTitle("New Project");
        this.setLayout((LayoutManager)new MigLayout());
        this.add(new JLabel("Project folder:"));
        this.textField = new JTextField();
        this.add((Component)this.textField, "growx, pushx");
        this.add((Component)this.newButton("...", ignore -> this.onSelectFolderClicked()), "wrap");
        this.add((Component)new JLabel("Add images to the project:"), "span, wrap");
        this.model = new LabkitProjectModel(context, null, new ArrayList<LabeledImage>());
        this.add((Component)new LabkitProjectEditor(this.model), "grow, span, wrap");
        this.add(this.newButton("Create Project", ignore -> this.onCreateProjectClicked()));
        this.add(this.newButton("Cancel", ignore -> this.onCancelClicked()));
    }

    private void onCancelClicked() {
        this.dispose();
    }

    private void onCreateProjectClicked() {
        this.approved = true;
        this.dispose();
    }

    private JButton newButton(String text, ActionListener actionListener) {
        JButton selectFolderButton = new JButton(text);
        selectFolderButton.addActionListener(actionListener);
        return selectFolderButton;
    }

    public static LabkitProjectModel show(Context context) {
        NewProjectDialog dialog = new NewProjectDialog(context);
        dialog.pack();
        dialog.setModal(true);
        dialog.setResizable(true);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        if (dialog.approved) {
            LabkitProjectModel newProject = dialog.getModel();
            try {
                LabkitProjectFileSerializer.save(newProject, new File(newProject.getProjectDirectory(), "labkit-project.yaml"));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Error while saving:\n" + e.getMessage(), "Create New Labkit Project", 0);
                return null;
            }
            return newProject;
        }
        return null;
    }

    private LabkitProjectModel getModel() {
        String projectDirectory = this.textField.getText();
        return new LabkitProjectModel(this.model.context(), projectDirectory, this.model.labeledImages());
    }

    private void onSelectFolderClicked() {
        File file;
        JFileChooser dialog = new JFileChooser();
        dialog.setCurrentDirectory(new File(this.textField.getText()));
        dialog.setFileSelectionMode(1);
        dialog.setDialogTitle("Select Project Folder");
        int returnValue = dialog.showOpenDialog(this);
        if (returnValue == 0 && this.checkFile(file = dialog.getSelectedFile())) {
            this.textField.setText(file.getAbsolutePath());
        }
    }

    private boolean checkFile(File file) {
        if (!file.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Please select a directory.");
            return false;
        }
        if (this.containsLabkitProjectFiles(file)) {
            int option = JOptionPane.showConfirmDialog(this, "The selected directory seems to already contain a Labkit project. Do you want to override it?", "Warning", 0);
            return option == 0;
        }
        return true;
    }

    private boolean containsLabkitProjectFiles(File file) {
        return new File(file, "labkit-project.yaml").exists();
    }

    public static void main(String ... args) {
        NewProjectDialog.show(null);
    }
}

