/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.segmentation;

import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import net.imagej.ImgPlus;
import net.imglib2.labkit.Extensible;
import net.imglib2.labkit.MenuBar;
import net.imglib2.labkit.labeling.Labeling;
import net.imglib2.labkit.models.SegmentationItem;
import net.imglib2.labkit.models.SegmenterListModel;
import net.imglib2.labkit.panel.GuiUtils;
import net.imglib2.labkit.utils.ParallelUtils;
import net.imglib2.labkit.utils.progress.SwingProgressWriter;
import net.imglib2.util.Pair;

public class TrainClassifier {
    private final SegmenterListModel model;

    public TrainClassifier(Extensible extensible, SegmenterListModel model) {
        this.model = model;
        extensible.addMenuItem(MenuBar.SEGMENTER_MENU, "Train Classifier", 1.0f, ignore -> TrainClassifier.trainSelectedSegmenter(model), null, "ctrl shift T");
        Consumer<SegmentationItem> train = item -> ParallelUtils.runInOtherThread(() -> {
            model.selectedSegmenter().set((SegmentationItem)item);
            TrainClassifier.trainSegmenter(model, item);
        });
        extensible.addMenuItem(SegmentationItem.SEGMENTER_MENU, "Train Classifier", 1.0f, train, GuiUtils.loadIcon("run.png"), null);
        extensible.addMenuItem(SegmentationItem.SEGMENTER_MENU, "Remove Classifier", 3.0f, model::remove, GuiUtils.loadIcon("remove.png"), null);
    }

    public static void trainSelectedSegmenter(SegmenterListModel model) {
        TrainClassifier.trainSegmenter(model, model.selectedSegmenter().get());
    }

    private static void trainSegmenter(SegmenterListModel model, SegmentationItem item) {
        TrainClassifier.train(model.trainingData().get(), item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void train(List<Pair<ImgPlus<?>, Labeling>> trainingData, SegmentationItem item) {
        SwingProgressWriter progressWriter = new SwingProgressWriter(null, "Training in Progress");
        progressWriter.setVisible(true);
        progressWriter.setProgressBarVisible(false);
        progressWriter.setDetailsVisible(false);
        try {
            item.train(trainingData);
        }
        catch (CancellationException e) {
            progressWriter.setVisible(false);
            JOptionPane.showMessageDialog(null, e.getMessage(), "Training Cancelled", -1);
        }
        catch (Throwable e) {
            progressWriter.setVisible(false);
            JOptionPane.showMessageDialog(null, e.toString(), "Training Failed", 2);
            e.printStackTrace();
        }
        finally {
            progressWriter.setVisible(false);
        }
    }
}

