/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.segmentation.weka;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.imglib2.trainable_segmentation.gui.FeatureSettingsUI;
import net.imglib2.trainable_segmentation.pixel_feature.filter.GroupedFeatures;
import net.imglib2.trainable_segmentation.pixel_feature.settings.FeatureSetting;
import net.imglib2.trainable_segmentation.pixel_feature.settings.FeatureSettings;
import net.imglib2.trainable_segmentation.pixel_feature.settings.GlobalSettings;
import net.miginfocom.swing.MigLayout;
import org.scijava.Context;

class TrainableSegmentationSettingsDialog {
    private final Context context;
    private final JFrame dialogParent;
    private boolean useGpu;
    private FeatureSettings featureSettings;
    private boolean okClicked = false;

    public TrainableSegmentationSettingsDialog(Context context, JFrame dialogParent, boolean useGpu, FeatureSettings defaultFeatureSettings) {
        this.context = context;
        this.dialogParent = dialogParent;
        this.useGpu = useGpu;
        this.featureSettings = defaultFeatureSettings;
    }

    public static void main(String ... args) {
        FeatureSettings defaultFeatureSettings = new FeatureSettings(GlobalSettings.default2d().build(), new FeatureSetting[]{GroupedFeatures.gauss()});
        TrainableSegmentationSettingsDialog dialog = new TrainableSegmentationSettingsDialog(new Context(), null, true, defaultFeatureSettings);
        dialog.show();
        if (dialog.okClicked()) {
            dialog.featureSettings().features().forEach(setting -> System.out.println(setting.getName()));
            System.out.println("Use Gpu: " + dialog.useGpu());
        }
    }

    public boolean useGpu() {
        return this.useGpu;
    }

    public FeatureSettings featureSettings() {
        return this.featureSettings;
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public void show() {
        JPanel dialogContent = new JPanel();
        dialogContent.setLayout((LayoutManager)new MigLayout("insets 0, gap 0", "[grow]", "[][grow]"));
        JCheckBox gpuCheckBox = this.initUseGpuCheckBox(dialogContent);
        FeatureSettingsUI featureSettingsUI = new FeatureSettingsUI(this.context, this.featureSettings);
        dialogContent.add((Component)featureSettingsUI, "grow");
        this.okClicked = this.showResizeableOkCancelDialog("Pixel Classification Settings", dialogContent);
        if (this.okClicked) {
            this.featureSettings = featureSettingsUI.get();
            this.useGpu = gpuCheckBox.isSelected();
        }
    }

    private JCheckBox initUseGpuCheckBox(JPanel dialogContent) {
        JCheckBox gpuCheckBox = new JCheckBox("(experimental, requires CLIJ2 and NVIDIA GPU)");
        JPanel topPanel = new JPanel();
        topPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 10px 0", "[]20px[grow]"));
        topPanel.add(new JLabel("Use GPU acceleration:"));
        topPanel.add(gpuCheckBox);
        gpuCheckBox.setSelected(this.useGpu);
        dialogContent.add((Component)topPanel, "grow, wrap");
        return gpuCheckBox;
    }

    private boolean showResizeableOkCancelDialog(String title, Component content) {
        JDialog dialog = new JDialog(this.dialogParent, title, true);
        JOptionPane optionPane = new JOptionPane(content, -1, 2);
        dialog.setContentPane(optionPane);
        dialog.setResizable(true);
        dialog.setDefaultCloseOperation(2);
        optionPane.addPropertyChangeListener(e -> {
            String prop = e.getPropertyName();
            if (dialog.isVisible() && e.getSource() == optionPane && "value".equals(prop)) {
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.setVisible(true);
        return optionPane.getValue().equals(0);
    }
}

