/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.utils;

import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;

public class LabkitUtils {
    public static long[] extend(long[] array, long value) {
        int length = array.length;
        long[] result = new long[length + 1];
        System.arraycopy(array, 0, result, 0, length);
        result[length] = value;
        return result;
    }

    public static int[] extend(int[] array, int value) {
        int length = array.length;
        int[] result = new int[length + 1];
        System.arraycopy(array, 0, result, 0, length);
        result[length] = value;
        return result;
    }

    public static RandomAccessibleInterval<FloatType> toFloat(RandomAccessibleInterval<? extends RealType<?>> rawData) {
        return Converters.convert(rawData, (in, out) -> out.set(in.getRealFloat()), (Type)new FloatType());
    }

    public static void copy(RandomAccessible<? extends IntegerType<?>> source, RandomAccessibleInterval<? extends IntegerType<?>> dest) {
        Views.interval((RandomAccessible)Views.pair(source, dest), dest).forEach(p -> ((IntegerType)p.getB()).setInteger(((IntegerType)p.getA()).getInteger()));
    }

    public static Img<UnsignedByteType> copyUnsignedBytes(RandomAccessibleInterval<? extends IntegerType<?>> source) {
        long[] dimensions = Intervals.dimensionsAsLongArray(source);
        ArrayImg dest = ArrayImgs.unsignedBytes((long[])dimensions);
        LabkitUtils.copy(source, dest);
        return dest;
    }

    public static <R extends NumericType<?>> Pair<Double, Double> estimateMinMax(RandomAccessibleInterval<R> rawData) {
        NumericType firstElement = (NumericType)rawData.randomAccess().get();
        if (firstElement instanceof UnsignedByteType) {
            return new ValuePair((Object)0.0, (Object)255.0);
        }
        if (firstElement instanceof ARGBType) {
            return new ValuePair((Object)0.0, (Object)255.0);
        }
        if (firstElement instanceof UnsignedShortType) {
            return LabkitUtils.tryEstimateMinMax((RandomAccessibleInterval)Cast.unchecked(rawData), 0.0, 65535.0);
        }
        if (firstElement instanceof RealType) {
            return LabkitUtils.tryEstimateMinMax((RandomAccessibleInterval)Cast.unchecked(rawData), 0.0, 1.0);
        }
        return new ValuePair((Object)0.0, (Object)255.0);
    }

    private static Pair<Double, Double> tryEstimateMinMax(RandomAccessibleInterval<? extends RealType<?>> rawData, double defaultMin, double defaultMax) {
        long size = Intervals.numElements(rawData);
        if ((double)size > 1.0E8) {
            return new ValuePair((Object)defaultMin, (Object)defaultMax);
        }
        return LabkitUtils.calculateMinMax(rawData);
    }

    private static Pair<Double, Double> calculateMinMax(RandomAccessibleInterval<? extends RealType<?>> rawData) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (RealType value : Views.iterable(rawData)) {
            double d = value.getRealDouble();
            min = Math.min(min, d);
            max = Math.max(max, d);
        }
        return new ValuePair((Object)min, (Object)max);
    }
}

