/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Notifier {
    private final List<Runnable> listeners = new CopyOnWriteArrayList<Runnable>();
    private final List<Reference<? extends Runnable>> weakListeners = new CopyOnWriteArrayList<Reference<? extends Runnable>>();
    private final ReferenceQueue<Runnable> queue = new ReferenceQueue();

    public void notifyListeners() {
        this.listeners.forEach(Runnable::run);
        this.cleanWeakListeners();
        this.weakListeners.forEach(reference -> {
            Runnable runnable = (Runnable)reference.get();
            if (runnable != null) {
                runnable.run();
            }
        });
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Runnable listener) {
        this.listeners.remove(listener);
    }

    public void addWeakListener(Runnable listener) {
        this.cleanWeakListeners();
        this.weakListeners.add(new WeakReference<Runnable>(listener, this.queue));
    }

    private void cleanWeakListeners() {
        Reference<Runnable> reference;
        while ((reference = this.queue.poll()) != null) {
            this.weakListeners.remove(reference);
        }
    }

    public void removeWeakListener(Runnable listener) {
        this.weakListeners.removeIf(reference -> {
            Runnable value = (Runnable)reference.get();
            return value == null || value == listener;
        });
    }
}

