/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class ParametricNotifier<T> {
    private final List<Consumer<T>> listeners = new CopyOnWriteArrayList<Consumer<T>>();
    private final List<Reference<? extends Consumer<T>>> weakListeners = new CopyOnWriteArrayList<Reference<? extends Consumer<T>>>();
    private final ReferenceQueue<Consumer<T>> queue = new ReferenceQueue();

    public void notifyListeners(T value) {
        this.listeners.forEach(listener -> listener.accept(value));
        this.cleanWeakListeners();
        this.weakListeners.forEach(reference -> {
            Consumer listener = (Consumer)reference.get();
            if (listener != null) {
                listener.accept(value);
            }
        });
    }

    public void addListener(Consumer<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Consumer<T> listener) {
        this.listeners.remove(listener);
    }

    public void addWeakListener(Consumer<T> listener) {
        this.cleanWeakListeners();
        this.weakListeners.add(new WeakReference<Consumer<T>>(listener, this.queue));
    }

    private void cleanWeakListeners() {
        Reference<Consumer<T>> reference;
        while ((reference = this.queue.poll()) != null) {
            this.weakListeners.remove(reference);
        }
    }

    public void removeWeakListener(Consumer<T> listener) {
        this.weakListeners.removeIf(reference -> {
            Consumer value = (Consumer)reference.get();
            return value == null || value == listener;
        });
    }
}

