/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.utils.progress;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;

public class PrintStreamToLines {
    public static PrintStream printStreamToLines(Consumer<String> linesConsumer) {
        return new PrintStream(new OutputStreamToLines(linesConsumer), true);
    }

    private static class OutputStreamToLines
    extends ByteArrayOutputStream {
        private final Consumer<String> consumer;
        private String prefix = "";

        public OutputStreamToLines(Consumer<String> consumer) {
            this.consumer = consumer;
        }

        @Override
        public synchronized void flush() {
            String text = this.toString();
            this.reset();
            this.process(text);
        }

        private void process(String s) {
            String[] lines = (this.prefix + s + "\ndummy").split("\n");
            int lastIndex = lines.length - 2;
            for (int i = 0; i < lastIndex; ++i) {
                this.consumer.accept(lines[i]);
            }
            this.prefix = lines[lastIndex];
        }
    }
}

