/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.utils.progress;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;

public class ProgressDialog {
    private final JDialog dialog;
    private final JLabel note = new JLabel("");
    private final JProgressBar progressBar = new JProgressBar(0, 1000);
    private final DetailsPane details = new DetailsPane();
    private long start;
    private boolean canceled = false;
    private boolean hide = false;

    public ProgressDialog(Frame parent, String text) {
        JOptionPane pane = new JOptionPane(new Object[]{text, this.note, this.progressBar, this.details}, 1, 2, null, new Object[]{"Hide", "Cancel"});
        pane.addPropertyChangeListener(this::buttonClicked);
        this.dialog = pane.createDialog(parent, text);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressDialog.this.hide = true;
            }
        });
        this.dialog.setResizable(true);
        this.dialog.setModal(false);
        this.dialog.add(pane);
        this.dialog.pack();
        this.progressBar.setStringPainted(true);
        this.start = System.currentTimeMillis();
    }

    private void buttonClicked(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("value")) {
            Object title = event.getNewValue();
            if ("Cancel".equals(title)) {
                this.canceled = true;
            }
            if ("Hide".equals(title)) {
                this.hide = true;
            }
        }
    }

    public void setNote(String note) {
        this.note.setText(note);
    }

    public void setProgress(double progress) {
        this.progressBar.getModel().setValue((int)(progress * 1000.0));
        String duration = this.timeEstimateAsString(progress);
        this.progressBar.setString(String.format("%.1f %%", progress * 100.0) + duration);
        this.setVisible(!this.canceled && !this.hide && progress < 1.0);
    }

    private String timeEstimateAsString(double progress) {
        if (progress <= 0.0) {
            this.start = System.currentTimeMillis();
            return "";
        }
        long seconds = (long)((double)(System.currentTimeMillis() - this.start) / 1000.0 / progress * (1.0 - progress));
        if (seconds < 60L) {
            return "";
        }
        long mins = seconds / 60L;
        long hours = mins / 60L;
        String result = String.format("%2d s", seconds % 60L);
        if (mins > 0L) {
            result = String.format("%2d min %s", mins % 60L, result);
        }
        if (hours > 0L) {
            result = String.format("%2d h %s", hours, result);
        }
        return "   " + result;
    }

    public void setVisible(boolean visible) {
        if (this.dialog.isVisible() == visible) {
            return;
        }
        if (visible) {
            this.dialog.setVisible(true);
        } else {
            this.dialog.dispose();
        }
    }

    public void addDetails(String line) {
        this.details.add(line);
    }

    public static void main(String ... args) throws InterruptedException {
        ProgressDialog dialog = new ProgressDialog(null, "Demonstrate ProgressDialog");
        int steps = 20;
        for (int i = 0; i < steps; ++i) {
            dialog.setProgress((double)i / (double)steps);
            dialog.setNote("Step " + i + " of " + steps);
            Thread.sleep(1000L);
            dialog.addDetails("Step " + i + " completed\n");
        }
        dialog.setProgress(1.0);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setProgressBarVisible(boolean visible) {
        this.progressBar.setVisible(visible);
    }

    public void setDetailsVisible(boolean visible) {
        this.details.setVisible(visible);
    }

    private static class DetailsPane
    extends JPanel {
        private final JTextArea text = new JTextArea();

        DetailsPane() {
            this.text.setBackground(Color.BLACK);
            this.text.setForeground(Color.LIGHT_GRAY);
            this.text.setFont(new Font("Monospaced", 1, 12));
            JScrollPane scrollPane = new JScrollPane(this.text);
            scrollPane.setVisible(false);
            this.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow]"));
            JCheckBox show_details = new JCheckBox("show Details");
            show_details.addItemListener(event -> scrollPane.setVisible(event.getStateChange() == 1));
            this.add((Component)show_details, "wrap");
            this.add((Component)scrollPane, "grow");
        }

        public void add(String line) {
            Document document = this.text.getDocument();
            try {
                document.insertString(document.getLength(), line + "\n", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

