/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labkit.utils.progress;

import bdv.export.ProgressWriter;
import java.io.PrintStream;
import java.util.concurrent.CancellationException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.imglib2.labkit.utils.progress.PrintStreamToLines;
import net.imglib2.labkit.utils.progress.ProgressDialog;

public class SwingProgressWriter
implements ProgressWriter {
    private final ProgressDialog dialog;
    private final PrintStream out = PrintStreamToLines.printStreamToLines(this::showNote);
    private final PrintStream err = PrintStreamToLines.printStreamToLines(this::showNote);

    public SwingProgressWriter(JFrame dialogParent, String title) {
        this.dialog = new ProgressDialog(dialogParent, title);
    }

    public PrintStream out() {
        return this.out;
    }

    public PrintStream err() {
        return this.err;
    }

    private void showNote(String line) {
        SwingUtilities.invokeLater(() -> {
            if (!line.isEmpty()) {
                this.dialog.setNote(line);
            }
            this.dialog.addDetails(line);
        });
    }

    public void setProgress(double completionRatio) {
        SwingUtilities.invokeLater(() -> this.dialog.setProgress(completionRatio));
        if (this.dialog.isCanceled()) {
            throw new CancellationException();
        }
    }

    public void setVisible(boolean visible) {
        this.dialog.setVisible(visible);
    }

    public void setProgressBarVisible(boolean visible) {
        this.dialog.setProgressBarVisible(visible);
    }

    public void setDetailsVisible(boolean visible) {
        this.dialog.setDetailsVisible(visible);
    }

    public static void main(String ... args) throws InterruptedException {
        SwingProgressWriter pw = new SwingProgressWriter(null, "SwingProgressWriter Demo");
        int steps = 30;
        for (int i = 0; i < steps; ++i) {
            pw.setProgress((double)i / (double)steps);
            pw.out().println("step " + i + " of " + steps);
            Thread.sleep(1000L);
        }
        pw.setProgress(1.0);
    }
}

